/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.CandleStickList;
import jp.robotbrain.signal.IndexStream;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.IndexStreamPort;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.NmIcon;
import jp.robotbrain.signal.StochasticsList;
import jp.robotbrain.signal.TypeIndexStream;

@TypeIndexStream(value="StochasticsList")
@InputComponentList(values={"@CandleStickList"})
@GeneDefaultLabelList(values={"ccountRange", "pcountD"})
public class StochasticsListStream
extends IndexStream {
    private static final long serialVersionUID = 1L;
    private final StochasticsList m_stochasticsList;

    public StochasticsListStream(String p_label, GeneList p_geneList, String p_ccountRangeLabel, String p_pcountDLabel) throws GeneListException, IndexStreamException {
        super(p_label, NmIcon.ZEROTO100);
        Gene ccountRangeGene = p_geneList.getGene(p_ccountRangeLabel);
        Gene pcountDGene = p_geneList.getGene(p_pcountDLabel);
        int ccountRange = ccountRangeGene.getIntValue();
        int pcountD = pcountDGene.getIntValue();
        this.m_stochasticsList = new StochasticsList(ccountRange, pcountD);
        int cost = Math.max(ccountRange, pcountD);
        this.setDestinationMaxCost(cost);
        this.getPortList().add("@CandleStickList", cost);
    }

    public StochasticsListStream(String p_label, GeneList p_geneList) throws GeneListException, IndexStreamException {
        super(p_label, NmIcon.ZEROTO100);
        int ccountRange = 0;
        int pcountD = 0;
        if (p_geneList.size() > 0) {
            Gene ccountRangeGene = p_geneList.getGene(0);
            Gene pcountDGene = p_geneList.getGene(1);
            ccountRange = ccountRangeGene.getIntValue();
            pcountD = pcountDGene.getIntValue();
        }
        this.m_stochasticsList = new StochasticsList(ccountRange, pcountD);
        int cost = Math.max(ccountRange, pcountD);
        this.setDestinationMaxCost(cost);
        this.getPortList().add("@CandleStickList", cost);
    }

    @Override
    public boolean notifyIndexSub() throws IndexStreamException {
        IndexStreamPort port = this.getPortList().get("@CandleStickList");
        if (!(port.getIndexStream().getValues() instanceof CandleStickList)) {
            throw new IndexStreamException("Instance Error");
        }
        this.m_stochasticsList.addObject((CandleStickList)port.getIndexStream().getValues());
        return this.notifyIndexNext();
    }

    public StochasticsList getValues() {
        return this.m_stochasticsList;
    }

    public StochasticsList getViewValues() {
        return this.m_stochasticsList;
    }

    @Override
    public void economizeMemory() {
        this.m_stochasticsList.setCapacity(this.getDestinationMaxCost());
    }

    @Override
    public void economizeMemory(int p_capacity) {
        int capacity = Math.max(p_capacity, this.getDestinationMaxCost());
        this.m_stochasticsList.setCapacity(capacity);
    }
}

