/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import java.util.ArrayList;
import java.util.Collections;
import jp.robotbrain.signal.EnabledDefaultSignal;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.JudgmentResult;
import jp.robotbrain.signal.NmIcon;
import jp.robotbrain.signal.NmSignal;
import jp.robotbrain.signal.Signal;
import jp.robotbrain.signal.SignalTagComparator;
import jp.robotbrain.signal.SimpleSignal;
import jp.robotbrain.signal.SummaryPriority;
import jp.robotbrain.signal.Tag;
import jp.robotbrain.signal.TypeSignalBlock;

@TypeSignalBlock
@EnabledDefaultSignal
@InputComponentList(values={"any@Signal"})
public class SignalBlock
extends Signal {
    private static final long serialVersionUID = 1L;
    private final ArrayList<Signal> m_inputSignalList = new ArrayList();

    public SignalBlock(String p_label, int p_priority) {
        super(p_label, NmIcon.BLOCK, p_priority);
    }

    @Override
    protected JudgmentResult getJudgmentResultSub() throws IndexStreamException {
        SummaryPriority sumPriority = this.getSummaryPriority();
        Tag inputTag = this.getInputTag();
        if (inputTag == null) {
            return null;
        }
        SimpleSignal max = sumPriority.getMaxSignal(inputTag);
        NmSignal returnValue = this.getDefaultSignal();
        if (max != null && max.getPriority() + sumPriority.getNeutral() >= 100) {
            returnValue = max.getLastJudgmentResult().getSignal();
        }
        return new JudgmentResult(inputTag, returnValue);
    }

    protected Tag getInputTag() throws IndexStreamException {
        if (this.m_inputSignalList.size() <= 0) {
            return null;
        }
        Signal max = null;
        try {
            max = Collections.max(this.m_inputSignalList, new SignalTagComparator());
        }
        catch (ClassCastException e) {
            return null;
        }
        if (max.getLastJudgmentResult() == null) {
            return null;
        }
        return max.getLastJudgmentResult().getTag();
    }

    public void addInputSignal(Signal p_tradeSignal) {
        this.m_inputSignalList.add(p_tradeSignal);
    }

    private SummaryPriority getSummaryPriority() throws IndexStreamException {
        SummaryPriority returnValue = new SummaryPriority();
        for (Signal inputSignal : this.m_inputSignalList) {
            if (inputSignal.getJudgmentResult() == null) continue;
            switch (inputSignal.getJudgmentResult().getSignal()) {
                case LONG: {
                    returnValue.addLong(inputSignal.getPriority());
                    break;
                }
                case SHORT: {
                    returnValue.addShort(inputSignal.getPriority());
                    break;
                }
                case ESCAPE: {
                    returnValue.addEscape(inputSignal.getPriority());
                    break;
                }
                case NEUTRAL: {
                    returnValue.addNeutral(inputSignal.getPriority());
                    break;
                }
                case ADD: {
                    returnValue.addAdd(inputSignal.getPriority());
                    break;
                }
                case SUB: {
                    returnValue.addSub(inputSignal.getPriority());
                    break;
                }
            }
        }
        return returnValue;
    }

    protected ArrayList<Signal> getInputSignalList() {
        return this.m_inputSignalList;
    }
}

