/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.CandleStick;
import jp.robotbrain.signal.CandleStickListStream;
import jp.robotbrain.signal.CandleStickTimeTable;
import jp.robotbrain.signal.IndexLine;
import jp.robotbrain.signal.IndexPoint;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.IndexStreamPort;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.SimpleLine;
import jp.robotbrain.signal.Tag;
import jp.robotbrain.signal.TypeIndexStream;

@TypeIndexStream(value="CandleStickList")
@InputComponentList(values={"@IndexLine"})
@GeneDefaultLabelList(values={"minute"})
public class CandleStickFactory
extends CandleStickListStream {
    private static final long serialVersionUID = 1L;
    private final CandleStickTimeTable m_timeTable;
    private final int m_minute;
    private String m_prevDate;
    private int m_prevArea = -1;
    private SimpleLine m_accumulateLine = new SimpleLine();

    public CandleStickFactory(String p_label, GeneList p_geneList, String p_minuteLabel) throws GeneListException, IndexStreamException {
        super(p_label, p_geneList, p_minuteLabel);
        Gene minute = p_geneList.getGene(p_minuteLabel);
        this.m_minute = minute.getIntValue();
        this.m_timeTable = this.m_minute >= 1440 ? null : new CandleStickTimeTable(this.m_minute);
        this.getPortList().add("@IndexLine", 1);
    }

    public CandleStickFactory(String p_label, GeneList p_geneList) throws IndexStreamException, GeneListException {
        super(p_label, p_geneList);
        this.m_minute = p_geneList.getGene(0).getIntValue();
        this.m_timeTable = this.m_minute >= 1440 ? null : new CandleStickTimeTable(this.m_minute);
        this.getPortList().add("@IndexLine", 1);
    }

    @Override
    public boolean notifyIndexSub() throws IndexStreamException {
        int area;
        IndexStreamPort port = this.getPortList().get("@IndexLine");
        if (!(port.getIndexStream().getValues() instanceof IndexLine)) {
            throw new IndexStreamException("Instance Error");
        }
        IndexPoint last = (IndexPoint)port.getIndexStream().getValues().getLast();
        if (this.m_minute >= 1440) {
            area = this.m_prevArea;
        } else {
            area = this.m_timeTable.lookup(last.getTag().getTime());
            if (this.m_prevArea == -1) {
                this.m_prevArea = area;
            }
        }
        if (this.m_prevDate == null) {
            this.m_prevDate = last.getTag().getDate();
        }
        if (!(this.m_prevArea == area && this.m_prevDate.equals(last.getTag().getDate()) || this.m_accumulateLine.size() <= 0)) {
            Tag tag = this.m_prevDate.equals(last.getTag().getDate()) ? last.getTag() : ((IndexPoint)this.m_accumulateLine.getLast()).getTag();
            CandleStick c = this.createCandleStick(tag, this.m_accumulateLine);
            this.getValues().add(c);
            boolean returnValue = this.notifyIndexNext();
            this.m_accumulateLine = new SimpleLine();
            this.m_accumulateLine.addPoint(last);
            this.m_prevArea = area;
            this.m_prevDate = last.getTag().getDate();
            return returnValue;
        }
        this.m_accumulateLine.addPoint(last);
        return false;
    }

    public void clearAccumulateLine() {
        this.m_accumulateLine.clear();
    }

    private CandleStick createCandleStick(Tag p_tag, IndexLine p_src) {
        if (p_src == null) {
            return null;
        }
        if (p_src.size() <= 0) {
            return null;
        }
        double open = ((IndexPoint)p_src.get(0)).getValue();
        double close = ((IndexPoint)p_src.getLast()).getValue();
        double high = p_src.getMax().getValue();
        double low = p_src.getMin().getValue();
        CandleStick c = new CandleStick(p_tag, open, high, low, close);
        return c;
    }
}

