/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.robotbrain.common.UtilResource;
import jp.robotbrain.signal.TagFormatException;

public class Tag
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String m_value;

    public Tag() {
        this.m_value = Tag.getNowDateTime();
    }

    public Tag(String p_tag) {
        this.m_value = p_tag.replace("/", "");
    }

    public Tag clone() {
        Tag returnValue = new Tag(this.m_value);
        return returnValue;
    }

    public boolean equals(Object p_other) {
        if (p_other == null) {
            return false;
        }
        if (this.getValue() == null) {
            return false;
        }
        if (p_other instanceof Tag) {
            Tag other = (Tag)p_other;
            return this.getValue().equals(other.getValue());
        }
        return false;
    }

    public int hashCode() {
        return this.m_value.hashCode();
    }

    public static Tag create() {
        return new Tag();
    }

    public static Tag create(String p_tag) throws TagFormatException {
        if (!Tag.checkTagStringFormat(p_tag)) {
            throw new TagFormatException(String.valueOf(UtilResource.getErrMsg("rtl_exception", TagFormatException.class, 0)) + p_tag);
        }
        return new Tag(p_tag);
    }

    private static boolean checkTagStringFormat(String p_tag) {
        Pattern p2;
        Matcher m2;
        Pattern p1;
        Matcher m1;
        String tag = p_tag.replace("/", "");
        if (tag.length() == 17 && (m1 = (p1 = Pattern.compile("([0-9]{8} [0-9]{2}:[0-9]{2} [0-9]{2})")).matcher(tag)).find()) {
            return true;
        }
        return tag.length() == 14 && (m2 = (p2 = Pattern.compile("([0-9]{8} [0-9]{2}:[0-9]{2})")).matcher(tag)).find();
    }

    public static String getNowDateTime() {
        Date date = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd HH:mm ss");
        return formatter.format(date);
    }

    public String getDate() {
        return this.m_value.substring(0, 8);
    }

    public String getYear() {
        return this.m_value.substring(0, 4);
    }

    public String getMonth() {
        return this.m_value.substring(4, 6);
    }

    public String getDay() {
        return this.m_value.substring(6, 8);
    }

    public String getTime() {
        return this.m_value.substring(9, 14);
    }

    public String getTimeSeconds() {
        return this.m_value.substring(9);
    }

    public int getHour() {
        return Integer.parseInt(this.m_value.substring(9, 11));
    }

    public int getMinutes() {
        return Integer.parseInt(this.m_value.substring(12, 14));
    }

    public int getSecond() {
        if (this.m_value.length() > 14) {
            return Integer.parseInt(this.m_value.substring(15, 17));
        }
        return 0;
    }

    public void setValue(String p_value) {
        this.m_value = p_value;
    }

    public String getValue() {
        return this.m_value;
    }

    public String getFormattedDate() {
        return String.valueOf(this.getYear()) + "/" + this.getMonth() + "/" + this.getDay();
    }

    public Calendar getCalendar() {
        int year = Integer.parseInt(this.getYear());
        int month = Integer.parseInt(this.getMonth()) - 1;
        int date = Integer.parseInt(this.getDay());
        int hourOfDay = this.getHour();
        int minute = this.getMinutes();
        int second = this.getSecond();
        Calendar returnValue = Calendar.getInstance();
        returnValue.set(year, month, date, hourOfDay, minute, second);
        return returnValue;
    }

    public int compareTime(String p_time) throws TagFormatException {
        int min;
        block9: {
            block8: {
                int hour;
                block7: {
                    if (p_time.length() != 5) {
                        throw new TagFormatException(String.valueOf(UtilResource.getErrMsg("rtl_exception", TagFormatException.class, 1)) + p_time);
                    }
                    try {
                        hour = Integer.parseInt(p_time.substring(0, 2));
                        min = Integer.parseInt(p_time.substring(3, 5));
                        if (this.getHour() <= hour) break block7;
                        return 1;
                    }
                    catch (NumberFormatException e) {
                        throw new TagFormatException(String.valueOf(UtilResource.getErrMsg("rtl_exception", TagFormatException.class, 1)) + p_time);
                    }
                }
                if (this.getHour() >= hour) break block8;
                return -1;
            }
            if (this.getMinutes() <= min) break block9;
            return 1;
        }
        if (this.getMinutes() < min) {
            return -1;
        }
        return 0;
    }

    public long calcTimeDifference(Tag p_other) {
        Calendar a = this.getCalendar();
        Calendar b = p_other.getCalendar();
        return Math.abs(a.getTimeInMillis() - b.getTimeInMillis()) / 1000L;
    }
}

