/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.IndexLine;
import jp.robotbrain.signal.IndexLineStream;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.IndexStreamPort;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.StdevLine;
import jp.robotbrain.signal.TypeIndexStream;

@TypeIndexStream(value="StdevLine")
@InputComponentList(values={"@IndexLine"})
@GeneDefaultLabelList(values={"pcount"})
public class StdevLineStream
extends IndexLineStream {
    private static final long serialVersionUID = 1L;
    private final StdevLine m_stdevLine;

    public StdevLineStream(String p_label, GeneList p_geneList, String p_pcountLabel) throws GeneListException {
        super(p_label);
        Gene pcountGene = p_geneList.getGene(p_pcountLabel);
        int cost = pcountGene.getIntValue();
        this.m_stdevLine = new StdevLine(cost);
        this.getPortList().add("@IndexLine", cost);
    }

    @Override
    public boolean notifyIndexSub() throws IndexStreamException {
        IndexStreamPort port = this.getPortList().get("@IndexLine");
        if (!(port.getIndexStream().getValues() instanceof IndexLine)) {
            throw new IndexStreamException("Instance Error");
        }
        this.m_stdevLine.addPoint((IndexLine)port.getIndexStream().getValues());
        return this.notifyIndexNext();
    }

    @Override
    public StdevLine getValues() {
        return this.m_stdevLine;
    }

    public StdevLine getViewValues() {
        return this.m_stdevLine;
    }

    @Override
    public void economizeMemory() {
        this.m_stdevLine.setCapacity(this.getDestinationMaxCost());
    }

    @Override
    public void economizeMemory(int p_capacity) {
        int capacity = Math.max(p_capacity, this.getDestinationMaxCost());
        this.m_stdevLine.setCapacity(capacity);
    }
}

