/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.signal.IndexLine;
import jp.robotbrain.signal.IndexPoint;
import jp.robotbrain.signal.NmViewType;

public class RsiLine
extends IndexLine {
    private static final long serialVersionUID = 1L;
    private final int m_pcount;

    public RsiLine(int p_pcount) {
        super(NmViewType.INDEXLINE_PERCENTAGE);
        this.m_pcount = p_pcount;
    }

    public void addPoint(IndexLine p_src) {
        if (p_src == null) {
            return;
        }
        if (p_src.size() < this.m_pcount) {
            return;
        }
        IndexLine tail = p_src.getTailLine(this.m_pcount);
        double sumPlus = 0.0;
        double sumMinus = 0.0;
        double prevValue = 0.0;
        IndexPoint f = (IndexPoint)tail.get(0);
        if (f == null) {
            return;
        }
        prevValue = f.getValue();
        int i = 1;
        while (i < tail.size()) {
            IndexPoint c = (IndexPoint)tail.get(i);
            if (prevValue < c.getValue()) {
                sumPlus += c.getValue() - prevValue;
            } else if (prevValue > c.getValue()) {
                sumMinus += prevValue - c.getValue();
            }
            prevValue = c.getValue();
            ++i;
        }
        double rsi = sumPlus / (sumPlus + sumMinus) * 100.0;
        IndexPoint lastPoint = (IndexPoint)p_src.getLast();
        this.add(new IndexPoint(lastPoint.getTag(), rsi));
    }
}

