/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.IndexLineStream;
import jp.robotbrain.signal.IndexObjectList;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.IndexStreamPort;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.LiteralLine;
import jp.robotbrain.signal.TypeIndexStream;

@TypeIndexStream(value="LiteralLine")
@InputComponentList(values={"@IndexObjectList"})
@GeneDefaultLabelList(values={"literalValue"})
public class LiteralLineStream
extends IndexLineStream {
    private static final long serialVersionUID = 1L;
    private final LiteralLine m_literalLine;

    public LiteralLineStream(String p_label, GeneList p_geneList, String p_literalValueLabel) throws GeneListException {
        super(p_label);
        Gene literalValueGene = p_geneList.getGene(p_literalValueLabel);
        double literalValue = literalValueGene.getDoubleValue();
        this.m_literalLine = new LiteralLine(literalValue);
        this.getPortList().add("@IndexObjectList", 1);
    }

    @Override
    public boolean notifyIndexSub() throws IndexStreamException {
        IndexStreamPort port = this.getPortList().get("@IndexObjectList");
        if (!(port.getIndexStream().getValues() instanceof IndexObjectList)) {
            throw new IndexStreamException("Instance Error");
        }
        this.m_literalLine.addPoint(port.getIndexStream().getValues());
        return this.notifyIndexNext();
    }

    @Override
    public LiteralLine getValues() {
        return this.m_literalLine;
    }

    public LiteralLine getViewValues() {
        return this.m_literalLine;
    }

    @Override
    public void economizeMemory() {
        this.m_literalLine.setCapacity(this.getDestinationMaxCost());
    }

    @Override
    public void economizeMemory(int p_capacity) {
        int capacity = Math.max(p_capacity, this.getDestinationMaxCost());
        this.m_literalLine.setCapacity(capacity);
    }
}

