/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.BollingerBandList;
import jp.robotbrain.signal.IndexLine;
import jp.robotbrain.signal.IndexStream;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.IndexStreamPort;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.TypeIndexStream;

@TypeIndexStream(value="BollingerBandList")
@InputComponentList(values={"@IndexLine"})
@GeneDefaultLabelList(values={"pcountCenter", "pcountStdev", "sigmaHigh", "sigmaLow"})
public class BollingerBandListStream
extends IndexStream {
    private static final long serialVersionUID = 1L;
    private final BollingerBandList m_bollingerBandList;

    public BollingerBandListStream(String p_label, GeneList p_geneList, String p_pcountCenterLabel, String p_pcountStdevLabel, String p_sigmaHighLabel, String p_sigmaLowLabel) throws GeneListException {
        super(p_label);
        Gene pcountCenterGene = p_geneList.getGene(p_pcountCenterLabel);
        Gene pcountStdevGene = p_geneList.getGene(p_pcountStdevLabel);
        Gene sigmaHighGene = p_geneList.getGene(p_sigmaHighLabel);
        Gene sigmaLowGene = p_geneList.getGene(p_sigmaLowLabel);
        int pcountCenter = pcountCenterGene.getIntValue();
        int pcountStdev = pcountStdevGene.getIntValue();
        double sigmaHigh = sigmaHighGene.getDoubleValue();
        double sigmaLow = sigmaLowGene.getDoubleValue();
        this.m_bollingerBandList = new BollingerBandList(pcountCenter, pcountStdev, sigmaHigh, sigmaLow);
        int cost = Math.max(pcountCenter, pcountStdev);
        this.getPortList().add("@IndexLine", cost);
    }

    @Override
    public boolean notifyIndexSub() throws IndexStreamException {
        IndexStreamPort port = this.getPortList().get("@IndexLine");
        if (!(port.getIndexStream().getValues() instanceof IndexLine)) {
            throw new IndexStreamException("Instance Error");
        }
        this.m_bollingerBandList.addObject((IndexLine)port.getIndexStream().getValues());
        return this.notifyIndexNext();
    }

    public BollingerBandList getValues() {
        return this.m_bollingerBandList;
    }

    public BollingerBandList getViewValues() {
        return this.m_bollingerBandList;
    }

    @Override
    public void economizeMemory() {
        this.m_bollingerBandList.setCapacity(this.getDestinationMaxCost());
    }

    @Override
    public void economizeMemory(int p_capacity) {
        int capacity = Math.max(p_capacity, this.getDestinationMaxCost());
        this.m_bollingerBandList.setCapacity(capacity);
    }
}

