/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.net;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import jp.robotbrain.common.TextFile;
import jp.robotbrain.common.UtilString;
import jp.robotbrain.html.HtmlForm;
import jp.robotbrain.html.HtmlFormException;
import jp.robotbrain.net.CookieException;
import jp.robotbrain.net.CookieList;
import jp.robotbrain.net.HttpHeader;
import jp.robotbrain.net.HttpHeaderList;
import jp.robotbrain.net.HttpRecvException;
import jp.robotbrain.net.HttpSendException;

public class Web {
    private URL m_url;
    private HttpURLConnection m_connection;
    private boolean m_autoRedirects = false;
    private CookieList m_cookieList = new CookieList();
    private final HttpHeaderList m_httpHeaderList;
    private final String m_charset;

    public Web(String p_charset) {
        this.m_charset = p_charset;
        this.m_httpHeaderList = new HttpHeaderList();
    }

    public Web(String p_charset, String p_httpUserAgent) {
        this.m_charset = p_charset;
        this.m_httpHeaderList = new HttpHeaderList();
        if (p_httpUserAgent != null && p_httpUserAgent.length() > 0) {
            this.m_httpHeaderList.add(new HttpHeader("User-Agent", p_httpUserAgent));
        }
    }

    private String getHtml(String p_URL, HttpHeaderList p_httpHeaderList) throws HttpSendException, HttpRecvException, CookieException {
        return this.readWeb(p_URL, "GET", p_httpHeaderList);
    }

    private void headHtml(String p_URL) throws HttpSendException, HttpRecvException, CookieException {
        this.readWeb(p_URL, "HEAD", this.m_httpHeaderList);
    }

    private String readWeb(String p_URL, String p_method, HttpHeaderList p_httpHeaderList) throws HttpSendException, HttpRecvException, CookieException {
        HttpHeader cookieHeader;
        HttpHeaderList reqHeader = new HttpHeaderList();
        if (p_httpHeaderList != null) {
            reqHeader.addList(p_httpHeaderList);
        }
        if ((cookieHeader = this.m_cookieList.createRequestCookie(p_URL, this.m_charset)) != null) {
            reqHeader.add(cookieHeader);
        }
        try {
            this.setURL(p_URL);
            if (reqHeader != null) {
                this.setRequestProperties(reqHeader);
            }
            if (p_method.equals("HEAD")) {
                this.doHead();
            } else if (p_method.equals("GET")) {
                this.doGet();
            } else {
                throw new HttpSendException("readWeb HttpMethodError Method=" + p_method + " URL=" + p_URL);
            }
            if (this.getStatusCode() >= 400) {
                this.m_connection.disconnect();
                reqHeader.print(System.out);
                throw new IOException("readWeb HttpError HttpStatusCode=" + this.getStatusCode() + " Method=" + p_method + " URL=" + p_URL);
            }
        }
        catch (IOException e) {
            throw new HttpSendException("readWeb SendError Msg=" + e.getMessage() + " Method=" + p_method + " URL=" + p_URL);
        }
        String returnValue = "";
        try {
            returnValue = this.getResponseText();
        }
        catch (IOException e) {
            throw new HttpRecvException("readWeb RecvError Msg=" + e.getMessage() + " Method=" + p_method + " URL=" + p_URL);
        }
        this.importResponseCookie();
        return returnValue;
    }

    public String postHtml(String p_URL, String p_queryString, HttpHeaderList p_httpHeaderList) throws HttpSendException, HttpRecvException, CookieException {
        HttpHeader cookieHeader;
        HttpHeaderList reqHeader = new HttpHeaderList();
        if (p_httpHeaderList != null) {
            reqHeader.addList(p_httpHeaderList);
        }
        if ((cookieHeader = this.m_cookieList.createRequestCookie(p_URL, this.m_charset)) != null) {
            reqHeader.add(cookieHeader);
        }
        if (reqHeader.get("Content-Type") == null) {
            reqHeader.add(new HttpHeader("Content-Type", "application/x-www-form-urlencoded"));
        }
        try {
            this.setURL(p_URL);
            if (reqHeader != null) {
                this.setRequestProperties(reqHeader);
            }
            this.doPost(p_queryString);
            if (this.getStatusCode() >= 400) {
                this.m_connection.disconnect();
                reqHeader.print(System.out);
                throw new HttpSendException("postHtml HttpError URL=" + p_URL + " QueryString=" + p_queryString + " HttpStatusCode=" + this.getStatusCode());
            }
        }
        catch (IOException e) {
            throw new HttpSendException("postHtml SendError URL=" + p_URL + " QueryString=" + p_queryString + " Msg=" + e.getMessage());
        }
        String returnValue = "";
        try {
            returnValue = this.getResponseText();
        }
        catch (IOException e) {
            throw new HttpRecvException("postHtml RecvError URL=" + p_URL + " QueryString=" + p_queryString + " Msg=" + e.getMessage());
        }
        this.importResponseCookie();
        return returnValue;
    }

    private void setURL(String p_URL) throws IOException {
        this.m_url = new URL(p_URL);
        this.m_connection = (HttpURLConnection)this.m_url.openConnection();
        if (!this.m_autoRedirects) {
            this.m_connection.setInstanceFollowRedirects(false);
        }
    }

    private void doHead() throws IOException {
        this.m_connection.setRequestMethod("HEAD");
        this.m_connection.connect();
    }

    private void doGet() throws IOException {
        this.m_connection.setRequestMethod("GET");
        this.m_connection.connect();
    }

    private void setRequestProperties(HttpHeaderList p_httpHeaderList) {
        int i = 0;
        while (i < p_httpHeaderList.size()) {
            HttpHeader hd = p_httpHeaderList.get(i);
            this.m_connection.setRequestProperty(hd.getName(), hd.getValue());
            ++i;
        }
    }

    private void doPost(String p_queryString) throws IOException {
        this.m_connection.setRequestMethod("POST");
        this.setRequestMessage(p_queryString);
        this.m_connection.connect();
    }

    private void setRequestMessage(String p_queryString) throws IOException {
        this.m_connection.setDoOutput(true);
        this.m_connection.setRequestProperty("Content-Length", Integer.toString(p_queryString.length()));
        BufferedWriter outer = new BufferedWriter(new OutputStreamWriter(this.m_connection.getOutputStream()));
        outer.write(p_queryString);
        outer.flush();
        outer.close();
    }

    private int getStatusCode() throws IOException {
        if (this.m_connection == null) {
            return -1;
        }
        return this.m_connection.getResponseCode();
    }

    protected void printHttpHeaderList() {
        if (this.m_connection == null) {
            return;
        }
        int i = 0;
        String name = "";
        String value = "";
        while (true) {
            name = this.m_connection.getHeaderFieldKey(++i);
            value = this.m_connection.getHeaderField(i);
            if (value == null) break;
            System.out.println(String.valueOf(name) + ":" + value);
        }
    }

    private HttpHeaderList getHttpHeaderList() {
        if (this.m_connection == null) {
            return null;
        }
        HttpHeaderList returnValue = new HttpHeaderList();
        int i = 0;
        while (true) {
            String name = this.m_connection.getHeaderFieldKey(++i);
            String value = this.m_connection.getHeaderField(i);
            if (value == null) break;
            returnValue.add(new HttpHeader(name, value));
        }
        return returnValue;
    }

    private void importResponseCookie() throws CookieException {
        if (this.m_connection == null) {
            return;
        }
        int i = 0;
        while (true) {
            String name = this.m_connection.getHeaderFieldKey(i);
            String value = this.m_connection.getHeaderField(i);
            if (value == null) break;
            if (name != null && name.equalsIgnoreCase("Set-Cookie")) {
                this.m_cookieList.importResponseCookie(this.getURL(), value);
            }
            ++i;
        }
    }

    private String getResponseHeaderValue(String p_name) {
        if (this.m_connection == null) {
            return "";
        }
        int i = 0;
        while (true) {
            String name = this.m_connection.getHeaderFieldKey(i);
            String value = this.m_connection.getHeaderField(i);
            if (value == null) break;
            if (name != null && name.equals(p_name)) {
                return value;
            }
            ++i;
        }
        return "";
    }

    private InputStream getResponseStream() throws IOException {
        return this.m_connection.getInputStream();
    }

    private String getResponseText() throws IOException {
        BufferedReader inner = new BufferedReader(new InputStreamReader(this.getResponseStream(), this.m_charset));
        String response = "";
        String line = "";
        while ((line = inner.readLine()) != null) {
            response = String.valueOf(response) + line + TextFile.LSP;
        }
        inner.close();
        return response;
    }

    public String sendForm(String p_URL, HtmlForm p_htmlForm) throws HttpSendException, HttpRecvException, CookieException, HtmlFormException {
        HttpHeaderList httpHeaderList = new HttpHeaderList();
        httpHeaderList.addList(this.m_httpHeaderList);
        HttpHeader httpHeader = this.getReferer();
        if (httpHeader != null) {
            httpHeaderList.add(httpHeader);
        }
        String returnValue = this.sendForm(p_URL, httpHeaderList, p_htmlForm);
        return returnValue;
    }

    private String sendForm(String p_URL, HttpHeaderList p_httpHeaderList, HtmlForm p_htmlForm) throws HttpSendException, HttpRecvException, CookieException, HtmlFormException {
        if (p_htmlForm.getAction().length() <= 0) {
            return null;
        }
        String returnValue = "";
        if (p_htmlForm.getMethod().equals("post")) {
            try {
                String queryString = p_htmlForm.createQueryString(this.m_charset);
                returnValue = this.postHtml(p_URL, queryString, p_httpHeaderList);
            }
            catch (UnsupportedEncodingException e) {
                throw new HttpSendException("sendForm POST createQueryStringError Msg=" + e.getMessage());
            }
        }
        try {
            String getUrl = String.valueOf(p_URL) + "?" + p_htmlForm.createQueryString(this.m_charset);
            returnValue = this.getHtml(getUrl, p_httpHeaderList);
        }
        catch (UnsupportedEncodingException e) {
            throw new HttpSendException("sendForm GET createQueryStringError Msg=" + e.getMessage());
        }
        String redirect = this.redirectHtml(p_httpHeaderList);
        if (!redirect.equals("")) {
            return redirect;
        }
        return returnValue;
    }

    public String go(String p_URL) throws HttpSendException, HttpRecvException, CookieException {
        HttpHeaderList httpHeaderList = new HttpHeaderList();
        httpHeaderList.addList(this.m_httpHeaderList);
        HttpHeader httpHeader = this.getReferer();
        if (httpHeader != null) {
            httpHeaderList.add(httpHeader);
        }
        String returnValue = this.go(p_URL, httpHeaderList);
        return returnValue;
    }

    public String go(String p_URL, HttpHeaderList p_httpHeaderList) throws HttpSendException, HttpRecvException, CookieException {
        String returnValue = this.getHtml(p_URL, p_httpHeaderList);
        String redirect = this.redirectHtml(p_httpHeaderList);
        if (!redirect.equals("")) {
            return redirect;
        }
        return returnValue;
    }

    private HttpHeader getReferer() {
        String prevUrl = this.getURL();
        if (prevUrl == null) {
            return null;
        }
        if (prevUrl.equals("")) {
            return null;
        }
        return new HttpHeader("Referer", prevUrl);
    }

    private String redirectHtml(HttpHeaderList p_httpHeaderList) throws HttpSendException, HttpRecvException, CookieException {
        String nextUrl;
        String returnValue = "";
        while (!(nextUrl = this.getResponseHeaderValue("Location")).equals("")) {
            returnValue = this.getHtml(nextUrl, p_httpHeaderList);
        }
        return returnValue;
    }

    public String getURL() {
        if (this.m_connection == null) {
            return null;
        }
        return this.m_connection.getURL().toString();
    }

    public static String getCharSet(String p_URL) {
        return Web.getCharSet(p_URL, null);
    }

    public static String getCharSet(String p_URL, String p_httpUserAgent) {
        try {
            String res;
            String meta;
            String returnValue = null;
            Web web = new Web("SJIS", p_httpUserAgent);
            web.headHtml(p_URL);
            HttpHeader header = web.getHttpHeaderList().get("Content-Type");
            if (header != null) {
                returnValue = Web.createCharset(header.getValue());
            }
            if (returnValue == null && (meta = Web.extractContentTypeTag(res = web.go(p_URL))) != null && meta.length() > 0) {
                returnValue = Web.createCharset(meta);
            }
            return returnValue;
        }
        catch (HttpSendException e) {
            return null;
        }
        catch (HttpRecvException e) {
            return null;
        }
        catch (CookieException e) {
            return null;
        }
    }

    private static String extractContentTypeTag(String p_src) {
        String regex = "<meta\\s*http-equiv\\s*=\\s*(?:Content-Type|\"Content-Type\"|'Content-Type')(.+?)>";
        return UtilString.findFirstRegexKeyword(p_src, regex, 1);
    }

    private static String createCharset(String p_src) {
        String charset = null;
        charset = UtilString.findFirstRegexKeyword(p_src, "(?:(charset\\s*=\\s*utf-8)|(charset\\s*=\\s*\"utf-8\")|(charset\\s*=\\s*'utf-8'))", 0);
        if (charset != null && charset.length() > 0) {
            return "UTF-8";
        }
        charset = UtilString.findFirstRegexKeyword(p_src, "(?:(charset\\s*=\\s*Shift_JIS)|(charset\\s*=\\s*\"Shift_JIS\")|(charset\\s*=\\s*'Shift_JIS'))", 0);
        if (charset != null && charset.length() > 0) {
            return "SJIS";
        }
        charset = UtilString.findFirstRegexKeyword(p_src, "(?:(charset\\s*=\\s*x-sjis)|(charset\\s*=\\s*\"x-sjis\")|(charset\\s*=\\s*'x-sjis'))", 0);
        if (charset != null && charset.length() > 0) {
            return "SJIS";
        }
        charset = UtilString.findFirstRegexKeyword(p_src, "(?:(charset\\s*=\\s*EUC-JP)|(charset\\s*=\\s*\"EUC-JP\")|(charset\\s*=\\s*'EUC-JP'))", 0);
        if (charset != null && charset.length() > 0) {
            return "EUC_JP";
        }
        return null;
    }
}

