/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import java.awt.Color;
import java.io.PrintStream;
import jp.robotbrain.signal.IndexObject;
import jp.robotbrain.signal.Tag;

public class IndexPoint
extends IndexObject {
    private static final long serialVersionUID = 1L;
    private double m_value;
    private Color m_color;

    public IndexPoint() {
        this.m_color = Color.BLACK;
    }

    public IndexPoint(Tag p_tag, int p_value) {
        super(p_tag);
        this.m_value = p_value;
        this.m_color = Color.BLACK;
    }

    public IndexPoint(Tag p_tag, double p_value) {
        super(p_tag);
        this.m_value = p_value;
        this.m_color = Color.BLACK;
    }

    public IndexPoint clone() {
        IndexPoint returnValue = new IndexPoint(this.getTag(), this.m_value);
        returnValue.setColor(this.m_color);
        return returnValue;
    }

    public final void setValue(double p_value) {
        this.m_value = p_value;
    }

    public final double getValue() {
        return this.m_value;
    }

    @Override
    public void printHeader(PrintStream p_out) {
        p_out.println("Tag,Value");
    }

    @Override
    public void print(PrintStream p_out) {
        p_out.println("'" + this.getTag().getValue() + "'," + this.getValue());
    }

    @Override
    public String toXml() {
        StringBuilder returnValue = new StringBuilder();
        returnValue.append("<indexpoint tag=\"");
        returnValue.append(this.getTag().getValue());
        returnValue.append("\">");
        returnValue.append("<value>");
        returnValue.append(this.getValue());
        returnValue.append("</value>");
        returnValue.append("</indexpoint>");
        return returnValue.toString();
    }

    public Color getColor() {
        return this.m_color;
    }

    public void setColor(Color p_color) {
        this.m_color = p_color;
    }
}

