/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.signal.CrossSignal;
import jp.robotbrain.signal.EnabledDefaultSignal;
import jp.robotbrain.signal.EnabledOutputSignal;
import jp.robotbrain.signal.IndexLine;
import jp.robotbrain.signal.IndexPoint;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.IndexStreamPort;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.JudgmentResult;
import jp.robotbrain.signal.NmSignal;
import jp.robotbrain.signal.TypeSignalStream;

@TypeSignalStream
@EnabledDefaultSignal
@EnabledOutputSignal
@InputComponentList(values={"slow@IndexLine", "fast@IndexLine", "*difference@IndexLine"})
public class CrossOverSignal
extends CrossSignal {
    private static final long serialVersionUID = 1L;

    public CrossOverSignal(String p_label, int p_priority, NmSignal p_outputSignal) {
        super(p_label, p_priority, p_outputSignal);
        this.getPortList().add("slow@IndexLine", 1);
        this.getPortList().add("fast@IndexLine", 1);
        this.getPortList().add("*difference@IndexLine", 1);
    }

    @Override
    protected JudgmentResult getJudgmentResultSub() throws IndexStreamException {
        IndexStreamPort slow = this.getPortList().get("slow@IndexLine");
        IndexStreamPort fast = this.getPortList().get("fast@IndexLine");
        IndexStreamPort difference = this.getPortList().get("*difference@IndexLine");
        if (slow == null) {
            throw new IndexStreamException("slow@IndexLine Port Null Error");
        }
        if (fast == null) {
            throw new IndexStreamException("fast@IndexLine Port Null Error");
        }
        if (difference == null) {
            throw new IndexStreamException("*difference@IndexLine Port Null Error");
        }
        if (slow.getIndexStream() == null) {
            return new JudgmentResult(null, NmSignal.NOSIGNAL);
        }
        if (fast.getIndexStream() == null) {
            return new JudgmentResult(null, NmSignal.NOSIGNAL);
        }
        if (slow.getIndexStream().getValues() == null) {
            return new JudgmentResult(null, NmSignal.NOSIGNAL);
        }
        if (fast.getIndexStream().getValues() == null) {
            return new JudgmentResult(null, NmSignal.NOSIGNAL);
        }
        if (!(slow.getIndexStream().getValues() instanceof IndexLine)) {
            throw new IndexStreamException("slow@IndexLine Instance Error");
        }
        if (!(fast.getIndexStream().getValues() instanceof IndexLine)) {
            throw new IndexStreamException("fast@IndexLine Instance Error");
        }
        IndexLine slowLine = (IndexLine)slow.getIndexStream().getValues();
        if (slowLine.size() < 1) {
            return new JudgmentResult(null, NmSignal.NOSIGNAL);
        }
        IndexLine fastLine = (IndexLine)fast.getIndexStream().getValues();
        if (fastLine.size() < 1) {
            return new JudgmentResult(null, NmSignal.NOSIGNAL);
        }
        IndexLine differenceLine = null;
        if (difference.getIndexStream() != null) {
            if (!(difference.getIndexStream().getValues() instanceof IndexLine)) {
                throw new IndexStreamException("*difference@IndexLine Instance Error");
            }
            differenceLine = (IndexLine)difference.getIndexStream().getValues();
            if (differenceLine.size() < 1) {
                return new JudgmentResult(null, NmSignal.NOSIGNAL);
            }
        }
        NmSignal returnValue = this.getDefaultSignal();
        double fastValue = ((IndexPoint)fastLine.getLast()).getValue();
        double slowValue = ((IndexPoint)slowLine.getLast()).getValue();
        double differenceValue = 0.0;
        if (differenceLine != null) {
            differenceValue = ((IndexPoint)differenceLine.getLast()).getValue();
        }
        if (this.isCrossOver(fastValue, slowValue, differenceValue)) {
            returnValue = this.getOutputSignal();
        }
        return new JudgmentResult(((IndexPoint)fastLine.getLast()).getTag(), returnValue);
    }
}

