/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;
import jp.robotbrain.common.UtilDouble;
import jp.robotbrain.graph.GraphLayer;
import jp.robotbrain.graph.GraphLayerList;
import jp.robotbrain.signal.CandleStick;
import jp.robotbrain.signal.IndexObject;
import jp.robotbrain.signal.IndexObjectList;
import jp.robotbrain.signal.IndexPoint;
import jp.robotbrain.signal.NmViewType;
import jp.robotbrain.signal.Tag;

public class GraphPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private GraphLayerList m_graphLayerList;
    private GraphLayerList m_paintGraphLayerList;
    private int m_pointWidth;
    private Color m_cursorColor;
    private int m_cursorX;
    private float m_lineWidth;
    private Color m_rulerColor;
    private int m_rulerDivCount;
    private Color m_titleBarBackColor;
    private Color m_titleBarForeColor;
    private IndexObjectList<IndexPoint> m_statusLine;

    public GraphPanel() {
        this.setBorder(null);
        this.m_graphLayerList = new GraphLayerList(this);
        this.m_paintGraphLayerList = new GraphLayerList(this);
        this.m_pointWidth = 3;
        this.m_cursorX = -1;
        this.m_lineWidth = 1.0f;
        this.m_cursorColor = Color.PINK;
        this.m_rulerColor = new Color(153, 153, 102);
        this.m_titleBarBackColor = new Color(102, 153, 51);
        this.m_titleBarForeColor = Color.WHITE;
        this.m_rulerDivCount = 5;
    }

    @Override
    public void paint(Graphics p_graphics) {
        super.paint(p_graphics);
        Graphics2D graphics2D = (Graphics2D)p_graphics;
        if (this.m_paintGraphLayerList.getValues().size() <= 0) {
            return;
        }
        for (GraphLayer layer : this.m_paintGraphLayerList.getValues()) {
            layer.setPrevTag(null);
            layer.setTitleBarHeight(this.calcStringHeight(graphics2D));
            layer.setIndexTopOffset(this.calcStringHeight(graphics2D));
        }
        GraphLayer mainLayer = this.getPaintMainLayer();
        if (mainLayer == null) {
            return;
        }
        if (mainLayer.getSrcList().size() < 2) {
            return;
        }
        int top = 0;
        GraphLayer prevLayer = null;
        int i = 0;
        while (i < this.m_paintGraphLayerList.getValues().size()) {
            GraphLayer layer = this.m_paintGraphLayerList.getValues().get(i);
            if (prevLayer != null && (layer.getOverLapNo() < 0 || layer.getOverLapNo() != prevLayer.getOverLapNo())) {
                top += this.getHeight() * prevLayer.getHeightRatio() / 100;
            }
            if (layer.getRuler().isVisible()) {
                layer.setTop(top);
                this.drawRulerAndTitleBar(graphics2D, layer);
            }
            prevLayer = layer;
            ++i;
        }
        this.drawCursor(graphics2D);
        i = 0;
        while (i < mainLayer.getSrcList().size()) {
            Object main = mainLayer.getSrcList().get(i);
            top = 0;
            prevLayer = null;
            for (GraphLayer layer : this.m_paintGraphLayerList.getValues()) {
                if (prevLayer != null && (layer.getOverLapNo() < 0 || layer.getOverLapNo() != prevLayer.getOverLapNo())) {
                    top += this.getHeight() * prevLayer.getHeightRatio() / 100;
                }
                layer.setTop(top);
                if (layer.getSrcList().getViewType() == NmViewType.INDEXLINE || layer.getSrcList().getViewType() == NmViewType.INDEXLINE_PERCENTAGE) {
                    this.drawIndexLine(graphics2D, layer, ((IndexObject)main).getTag());
                } else if (layer.getSrcList().getViewType() == NmViewType.CANDLESTICKLIST) {
                    this.drawCandleStickList(graphics2D, layer, ((IndexObject)main).getTag());
                }
                prevLayer = layer;
            }
            ++i;
        }
    }

    private GraphLayer getPaintMainLayer() {
        if (this.m_paintGraphLayerList.getValues().size() <= 0) {
            return null;
        }
        return this.m_paintGraphLayerList.getValues().get(0);
    }

    protected GraphLayer getMainLayer() {
        if (this.m_graphLayerList.getValues().size() <= 0) {
            return null;
        }
        return this.m_graphLayerList.getValues().get(0);
    }

    private void drawCursor(Graphics2D p_graphics2D) {
        BasicStroke stroke = new BasicStroke(1.0f);
        p_graphics2D.setStroke(stroke);
        p_graphics2D.setColor(this.m_cursorColor);
        p_graphics2D.fillRect(this.getCursorXPointCount() * this.m_pointWidth, 0, this.m_pointWidth, this.getHeight());
    }

    private int calcStringWidth(Graphics2D p_graphics2D, String p_value) {
        FontMetrics fm = p_graphics2D.getFontMetrics();
        int returnValue = 0;
        int j = 0;
        while (j < p_value.length()) {
            returnValue += fm.charWidth(p_value.charAt(j));
            ++j;
        }
        return returnValue;
    }

    private int calcStringHeight(Graphics2D p_graphics2D) {
        FontMetrics fm = p_graphics2D.getFontMetrics();
        return fm.getHeight();
    }

    private void drawRulerAndTitleBar(Graphics2D p_graphics2D, GraphLayer p_layer) {
        double begin;
        BasicStroke stroke = new BasicStroke(1.0f);
        p_graphics2D.setStroke(stroke);
        p_graphics2D.setColor(this.m_titleBarBackColor);
        int tabTopY = p_layer.getTitleBarTop();
        int tabBottomY = p_layer.getTitleBarTop() + p_layer.getTitleBarHeight();
        p_graphics2D.fillRect(0, tabTopY, this.getWidth(), p_layer.getTitleBarHeight());
        p_graphics2D.setColor(this.m_titleBarForeColor);
        p_graphics2D.drawString(p_layer.getTitle(), 4, tabBottomY - (int)((double)p_layer.getTitleBarHeight() * 0.2));
        float[] dash = new float[]{2.0f, 3.0f};
        stroke = new BasicStroke(1.0f, 0, 0, 10.0f, dash, 0.0f);
        p_graphics2D.setStroke(stroke);
        p_graphics2D.setColor(this.m_rulerColor);
        double range = p_layer.getMax() - p_layer.getMin();
        double rulerSize = UtilDouble.fix(range / (double)this.m_rulerDivCount / p_layer.getRuler().getMinUnit(), 0);
        if (rulerSize < 1.0) {
            rulerSize = 1.0;
        }
        double step = rulerSize * p_layer.getRuler().getMinUnit();
        double i = begin = UtilDouble.fix(step * UtilDouble.fix(p_layer.getMax() / step, 0), p_layer.getIndexScale());
        while (i >= p_layer.getMin()) {
            int y = p_layer.calcY(i, this.getHeight());
            p_graphics2D.drawLine(0, y, this.getWidth(), y);
            String viewString = UtilDouble.format(i, p_layer.getIndexScale());
            int viewStringWidth = this.calcStringWidth(p_graphics2D, viewString);
            p_graphics2D.drawString(viewString, this.getWidth() / 3 - viewStringWidth, y - 1);
            p_graphics2D.drawString(viewString, this.getWidth() - viewStringWidth - 10, y - 1);
            i -= step;
        }
    }

    private void drawIndexLine(Graphics2D p_graphics2D, GraphLayer p_layer, Tag p_mainLayerTag) {
        IndexPoint current = (IndexPoint)p_layer.getSrcList().get(p_mainLayerTag);
        if (current == null) {
            return;
        }
        IndexPoint prev = (IndexPoint)p_layer.getSrcList().get(p_layer.getPrevTag());
        if (prev == null) {
            p_layer.setPrevTag(p_mainLayerTag);
            return;
        }
        int prevPointer = p_layer.getSrcList().indexOf(prev);
        int currentPointer = p_layer.getSrcList().indexOf(current);
        int prevX = prevPointer * this.m_pointWidth;
        int currentX = currentPointer * this.m_pointWidth;
        int prevY = p_layer.calcY(prev.getValue(), this.getHeight());
        int currentY = p_layer.calcY(current.getValue(), this.getHeight());
        BasicStroke stroke = new BasicStroke(this.m_lineWidth);
        p_graphics2D.setStroke(stroke);
        if (p_layer.isStatusColor() && this.m_statusLine != null) {
            IndexPoint status = this.m_statusLine.get(prev.getTag());
            if (status != null) {
                p_graphics2D.setColor(status.getColor());
            }
        } else {
            p_graphics2D.setColor(p_layer.getForeColor());
        }
        p_graphics2D.drawLine(prevX, prevY, currentX - 1, currentY);
        p_layer.setPrevTag(p_mainLayerTag);
    }

    private void drawCandleStickList(Graphics2D p_graphics2D, GraphLayer p_layer, Tag p_mainLayerTag) {
        CandleStick current = (CandleStick)p_layer.getSrcList().get(p_mainLayerTag);
        if (current == null) {
            return;
        }
        int currentPointer = this.getPaintMainLayer().getSrcList().indexOf(current);
        int currentX = currentPointer * this.m_pointWidth;
        int currentY = 0;
        int height = 0;
        int higeHighY = -1;
        int higeLowY = -1;
        Color fillColor = Color.WHITE;
        if (current.getOpen() <= current.getClose()) {
            currentY = p_layer.calcY(current.getClose(), this.getHeight());
            height = p_layer.calcYDistance(current.getClose() - current.getOpen(), this.getHeight());
            fillColor = current.getPlusColor();
            if (current.getHigh() > current.getClose()) {
                higeHighY = p_layer.calcY(current.getHigh(), this.getHeight());
            }
            if (current.getLow() < current.getOpen()) {
                higeLowY = p_layer.calcY(current.getLow(), this.getHeight());
            }
        } else {
            currentY = p_layer.calcY(current.getOpen(), this.getHeight());
            height = p_layer.calcYDistance(current.getOpen() - current.getClose(), this.getHeight());
            fillColor = current.getMinusColor();
            if (current.getHigh() > current.getOpen()) {
                higeHighY = p_layer.calcY(current.getHigh(), this.getHeight());
            }
            if (current.getLow() < current.getClose()) {
                higeLowY = p_layer.calcY(current.getLow(), this.getHeight());
            }
        }
        BasicStroke stroke = new BasicStroke(this.m_lineWidth);
        p_graphics2D.setStroke(stroke);
        if (p_layer.isStatusColor() && this.m_statusLine != null) {
            IndexPoint status = this.m_statusLine.get(p_mainLayerTag);
            if (status != null) {
                p_graphics2D.setColor(status.getColor());
            }
        } else {
            p_graphics2D.setColor(p_layer.getForeColor());
        }
        p_graphics2D.drawRect(currentX, currentY, this.m_pointWidth - 1, height);
        int higeX = currentX + this.m_pointWidth / 2;
        if (higeHighY > 0) {
            p_graphics2D.drawLine(higeX, currentY, higeX, higeHighY);
        }
        if (higeLowY > 0) {
            p_graphics2D.drawLine(higeX, currentY, higeX, higeLowY);
        }
        p_graphics2D.setColor(fillColor);
        int fillOffset = Math.round(this.m_lineWidth / 2.0f);
        int lineWidth = (int)this.m_lineWidth;
        p_graphics2D.fillRect(currentX + fillOffset, currentY + fillOffset, this.m_pointWidth - lineWidth - 1, height - lineWidth * 1);
        p_layer.setPrevTag(p_mainLayerTag);
    }

    public int getCursorXPointCount() {
        return this.m_cursorX / this.m_pointWidth;
    }

    public int getWidthPointCount() {
        return this.getWidth() / this.m_pointWidth;
    }

    public IndexObject getCursorPoint() {
        if (this.m_statusLine == null) {
            return null;
        }
        int tailIndex = this.getWidthPointCount() - this.getCursorXPointCount();
        GraphLayer mainLayer = this.getPaintMainLayer();
        if (mainLayer.getSrcList().size() <= tailIndex) {
            return null;
        }
        Object src = mainLayer.getSrcList().get(mainLayer.getSrcList().size() - tailIndex);
        if (src == null) {
            return null;
        }
        return this.m_statusLine.get(((IndexObject)src).getTag());
    }

    public void movePrevCursor() {
        if (this.m_cursorX - this.m_pointWidth > 0) {
            this.m_cursorX -= this.m_pointWidth;
        }
    }

    public void moveNextCursor() {
        if (this.m_cursorX + this.m_pointWidth < this.getWidth()) {
            this.m_cursorX += this.m_pointWidth;
        }
    }

    public void setCursorX(int p_cursorX) {
        this.m_cursorX = p_cursorX;
    }

    public Color getCursorColor() {
        return this.m_cursorColor;
    }

    public void setCursorColor(Color p_cursorColor) {
        this.m_cursorColor = p_cursorColor;
    }

    public int getPointWidth() {
        return this.m_pointWidth;
    }

    public void setPointWidth(int p_pointWidth) {
        this.m_pointWidth = p_pointWidth;
    }

    public float getLineWidth() {
        return this.m_lineWidth;
    }

    public void setLineWidth(float p_lineWidth) {
        this.m_lineWidth = p_lineWidth;
    }

    public Color getRulerColor() {
        return this.m_rulerColor;
    }

    public void setRulerColor(Color p_rulerColor) {
        this.m_rulerColor = p_rulerColor;
    }

    public Color getTitleBarBackColor() {
        return this.m_titleBarBackColor;
    }

    public void setTitleBarBackColor(Color p_titleBarBackColor) {
        this.m_titleBarBackColor = p_titleBarBackColor;
    }

    public Color getTitleBarForeColor() {
        return this.m_titleBarForeColor;
    }

    public void setTitleBarForeColor(Color p_titleBarForeColor) {
        this.m_titleBarForeColor = p_titleBarForeColor;
    }

    public int getRulerDivCount() {
        return this.m_rulerDivCount;
    }

    public void setRulerDivCount(int p_rulerDivCount) {
        this.m_rulerDivCount = p_rulerDivCount;
    }

    public void setStatusLine(IndexObjectList<IndexPoint> p_statusLine) {
        this.m_statusLine = p_statusLine;
    }

    public GraphLayerList getGraphLayerList() {
        return this.m_graphLayerList;
    }

    public void preparePaint() {
        this.m_paintGraphLayerList = this.m_graphLayerList;
        this.m_paintGraphLayerList.init();
        this.m_graphLayerList = new GraphLayerList(this);
    }
}

