/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.signal.EntryPoint;
import jp.robotbrain.signal.FrameworkParameter;
import jp.robotbrain.signal.IndexLine;
import jp.robotbrain.signal.IndexLineStream;
import jp.robotbrain.signal.IndexObjectList;
import jp.robotbrain.signal.IndexPoint;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.SimpleLine;
import jp.robotbrain.signal.TypeIndexStream;

@EntryPoint
@FrameworkParameter
@TypeIndexStream(value="SimpleLine")
@InputComponentList(values={"@IndexLine"})
public class SimpleLineStream
extends IndexLineStream {
    private static final long serialVersionUID = 1L;
    private final SimpleLine m_simpleLine = new SimpleLine();

    public SimpleLineStream(String p_label) {
        super(p_label);
    }

    public void enter(IndexPoint p_src) throws IndexStreamException {
        if (p_src == null) {
            throw new IndexStreamException("Null Error");
        }
        this.m_simpleLine.addPoint(p_src);
        this.notifyIndexNext(this.m_simpleLine);
    }

    @Override
    public void notifyIndexSub(IndexObjectList<?> p_indexObjectList) throws IndexStreamException {
        if (!(p_indexObjectList instanceof IndexLine)) {
            throw new IndexStreamException("Instance Error");
        }
        if (p_indexObjectList.size() > 0) {
            IndexLine il = (IndexLine)p_indexObjectList;
            this.m_simpleLine.addPoint((IndexPoint)il.getLast());
        }
        this.notifyIndexNext(this.m_simpleLine);
    }

    @Override
    public SimpleLine getValues() {
        return this.m_simpleLine;
    }

    @Override
    public int getCost() {
        return 1;
    }

    @Override
    public void economizeCapacity() {
        this.m_simpleLine.setCapacity(this.getDestinationMaxCost());
    }
}

