/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.IndexLine;
import jp.robotbrain.signal.IndexLineStream;
import jp.robotbrain.signal.IndexObjectList;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.RsiLine;
import jp.robotbrain.signal.TypeIndexStream;

@TypeIndexStream(value="RsiLine")
@InputComponentList(values={"@IndexLine"})
@GeneDefaultLabelList(values={"pcount"})
public class RsiLineStream
extends IndexLineStream {
    private static final long serialVersionUID = 1L;
    private final RsiLine m_rsiLine;
    private int m_cost;

    public RsiLineStream(String p_label, GeneList p_geneList, String p_pcountLabel) throws GeneListException {
        super(p_label);
        Gene pcountGene = p_geneList.getGene(p_pcountLabel);
        this.m_cost = pcountGene.getIntValue();
        this.m_rsiLine = new RsiLine(this.m_cost);
    }

    public void enter(IndexLine p_src) throws IndexStreamException {
        this.notifyIndex(p_src);
    }

    @Override
    public void notifyIndexSub(IndexObjectList<?> p_indexObjectList) throws IndexStreamException {
        if (!(p_indexObjectList instanceof IndexLine)) {
            throw new IndexStreamException("Instance Error");
        }
        this.m_rsiLine.addPoint((IndexLine)p_indexObjectList);
        this.notifyIndexNext(this.m_rsiLine);
    }

    @Override
    public RsiLine getValues() {
        return this.m_rsiLine;
    }

    @Override
    public int getCost() {
        return this.m_cost;
    }

    @Override
    public void economizeCapacity() {
        this.m_rsiLine.setCapacity(this.getDestinationMaxCost());
    }
}

