/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.CandleStickList;
import jp.robotbrain.signal.ChannelHighLine;
import jp.robotbrain.signal.ChannelLowLine;
import jp.robotbrain.signal.IndexLineStream;
import jp.robotbrain.signal.IndexObject;
import jp.robotbrain.signal.IndexObjectList;
import jp.robotbrain.signal.IndexPoint;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.SimpleLine;
import jp.robotbrain.signal.Tag;
import jp.robotbrain.signal.TypeIndexStream;

@TypeIndexStream(value="SimpleLine")
@InputComponentList(values={"@CandleStickList"})
@GeneDefaultLabelList(values={"ccount"})
public class HighLowDifferenceStream
extends IndexLineStream {
    private static final long serialVersionUID = 1L;
    private final SimpleLine m_HighLowDifferenceLine;
    private final ChannelHighLine m_channelHighLine;
    private final ChannelLowLine m_channelLowLine;
    private int m_cost;

    public HighLowDifferenceStream(String p_label, GeneList p_geneList, String p_ccountLabel) throws GeneListException {
        super(p_label);
        Gene ccountGene = p_geneList.getGene(p_ccountLabel);
        this.m_cost = ccountGene.getIntValue();
        this.m_HighLowDifferenceLine = new SimpleLine();
        this.m_channelHighLine = new ChannelHighLine(this.m_cost);
        this.m_channelLowLine = new ChannelLowLine(this.m_cost);
    }

    public void enter(CandleStickList p_src) throws IndexStreamException {
        this.notifyIndex(p_src);
    }

    @Override
    public void notifyIndexSub(IndexObjectList<?> p_indexObjectList) throws IndexStreamException {
        if (!(p_indexObjectList instanceof CandleStickList)) {
            throw new IndexStreamException("Instance Error");
        }
        this.m_channelHighLine.addPoint((CandleStickList)p_indexObjectList);
        this.m_channelLowLine.addPoint((CandleStickList)p_indexObjectList);
        if (p_indexObjectList.size() > 0) {
            Tag tag = ((IndexObject)p_indexObjectList.getLast()).getTag();
            if (this.m_channelHighLine.size() > 0 && this.m_channelLowLine.size() > 0) {
                double high = ((IndexPoint)this.m_channelHighLine.getLast()).getValue();
                double low = ((IndexPoint)this.m_channelLowLine.getLast()).getValue();
                this.m_HighLowDifferenceLine.addPoint(new IndexPoint(tag, high - low));
            } else {
                this.m_HighLowDifferenceLine.addPoint(new IndexPoint(tag, 0));
            }
        }
        this.notifyIndexNext(this.m_HighLowDifferenceLine);
    }

    @Override
    public SimpleLine getValues() {
        return this.m_HighLowDifferenceLine;
    }

    @Override
    public int getCost() {
        return this.m_cost;
    }

    @Override
    public void economizeCapacity() {
        this.m_HighLowDifferenceLine.setCapacity(this.getDestinationMaxCost());
        this.m_channelHighLine.setCapacity(this.getDestinationMaxCost());
        this.m_channelLowLine.setCapacity(this.getDestinationMaxCost());
    }
}

