/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.IndexLine;
import jp.robotbrain.signal.IndexObjectList;
import jp.robotbrain.signal.IndexStream;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.MacdLine;
import jp.robotbrain.signal.TypeIndexStream;

@TypeIndexStream(value="MacdLine")
@InputComponentList(values={"@IndexLine"})
@GeneDefaultLabelList(values={"pcountShortTermEma", "pcountLongTermEma"})
public class MacdLineStream
extends IndexStream {
    private static final long serialVersionUID = 1L;
    private final MacdLine m_macdLine;
    private int m_cost;

    public MacdLineStream(String p_label, GeneList p_geneList, String p_pcountShortTermEmaLabel, String p_pcountLongTermEmaLabel) throws GeneListException {
        super(p_label);
        Gene pcountShortTermEmaGene = p_geneList.getGene(p_pcountShortTermEmaLabel);
        Gene pcountLongTermEmaGene = p_geneList.getGene(p_pcountLongTermEmaLabel);
        int pcountShortTermEma = pcountShortTermEmaGene.getIntValue();
        int pcountLongTermEma = pcountLongTermEmaGene.getIntValue();
        this.m_macdLine = new MacdLine(pcountShortTermEma, pcountLongTermEma);
        this.m_cost = Math.max(pcountShortTermEma, pcountLongTermEma);
    }

    public void enter(IndexLine p_src) throws IndexStreamException {
        this.notifyIndex(p_src);
    }

    @Override
    public void notifyIndexSub(IndexObjectList<?> p_indexObjectList) throws IndexStreamException {
        if (!(p_indexObjectList instanceof IndexLine)) {
            throw new IndexStreamException("Instance Error");
        }
        this.m_macdLine.addObject((IndexLine)p_indexObjectList);
        this.notifyIndexNext(this.m_macdLine);
    }

    public MacdLine getValues() {
        return this.m_macdLine;
    }

    @Override
    public int getCost() {
        return this.m_cost;
    }

    @Override
    public void economizeCapacity() {
        this.m_macdLine.setCapacity(this.getDestinationMaxCost());
    }
}

