/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.IndexLine;
import jp.robotbrain.signal.IndexObjectList;
import jp.robotbrain.signal.IndexStream;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.MultiplicationLine;
import jp.robotbrain.signal.TypeIndexStream;

@TypeIndexStream(value="MultiplicationLine")
@InputComponentList(values={"@IndexLine"})
@GeneDefaultLabelList(values={"magnification"})
public class MultiplicationLineStream
extends IndexStream {
    private static final long serialVersionUID = 1L;
    private final MultiplicationLine m_multiplicationLine;

    public MultiplicationLineStream(String p_label, GeneList p_geneList, String p_magnificationLabel) throws GeneListException {
        super(p_label);
        Gene magnificationGene = p_geneList.getGene(p_magnificationLabel);
        double magnification = magnificationGene.getDoubleValue();
        this.m_multiplicationLine = new MultiplicationLine(magnification);
    }

    public void enter(IndexLine p_src) throws IndexStreamException {
        this.notifyIndex(p_src);
    }

    @Override
    public void notifyIndex(IndexObjectList<?> p_indexObjectList) throws IndexStreamException {
        if (p_indexObjectList == null) {
            throw new IndexStreamException("Null Error");
        }
        if (!(p_indexObjectList instanceof IndexLine)) {
            throw new IndexStreamException("Instance Error");
        }
        if (p_indexObjectList.size() <= 0) {
            return;
        }
        int prevSize = this.m_multiplicationLine.size();
        this.m_multiplicationLine.addPoint((IndexLine)p_indexObjectList);
        if (this.m_multiplicationLine.size() > prevSize) {
            this.notifyIndexNext(this.m_multiplicationLine);
        }
    }

    public MultiplicationLine getValues() {
        return this.m_multiplicationLine;
    }
}

