/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.ConcurrentHashMap;
import jp.robotbrain.signal.IndexStreamException;

public class CandleStickTimeTable {
    private ConcurrentHashMap<String, Integer> m_timetable;

    public CandleStickTimeTable(int p_minute) throws IndexStreamException {
        try {
            InputStream istream = this.getClass().getResourceAsStream("cstable/" + p_minute + ".txt");
            if (istream == null) {
                throw new IndexStreamException("Candlestick TimeTable Not Found: minute=" + p_minute);
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(istream));
            this.m_timetable = new ConcurrentHashMap();
            while (br.ready()) {
                String line = br.readLine();
                String[] cols = line.split(",");
                if (cols.length != 2) {
                    throw new IndexStreamException("Candlestick TimeTable Format Error: col=" + cols.length);
                }
                this.m_timetable.put(cols[0], Integer.parseInt(cols[1]));
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            throw new IndexStreamException("Candlestick TimeTable FileNotFoundException: " + e.getMessage());
        }
        catch (IOException e) {
            throw new IndexStreamException("Candlestick TimeTable IOException: " + e.getMessage());
        }
    }

    public int lookup(String p_time) {
        return this.m_timetable.get(p_time);
    }
}

