/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import java.io.PrintStream;
import jp.robotbrain.signal.IndexObject;
import jp.robotbrain.signal.Tag;

public class IndexPoint
extends IndexObject {
    private static final long serialVersionUID = 1L;
    private final int m_value;
    private final double m_doubleValue;

    public IndexPoint(Tag p_tag, int p_value) {
        super(p_tag);
        this.m_value = p_value;
        this.m_doubleValue = p_value;
    }

    public IndexPoint(Tag p_tag, double p_value) {
        super(p_tag);
        this.m_doubleValue = p_value;
        this.m_value = (int)p_value;
    }

    public IndexPoint clone() {
        return new IndexPoint(this.getTag(), this.m_doubleValue);
    }

    public final int getIntValue() {
        return this.m_value;
    }

    public final double getValue() {
        return this.m_doubleValue;
    }

    @Override
    public void printHeader(PrintStream p_out) {
        p_out.println("Tag,Value");
    }

    @Override
    public void print(PrintStream p_out) {
        p_out.println("'" + this.getTag().getString() + "'," + this.getValue());
    }

    @Override
    public String toXml() {
        StringBuilder returnValue = new StringBuilder();
        returnValue.append("<indexpoint tag=\"");
        returnValue.append(this.getTag().getString());
        returnValue.append("\">");
        returnValue.append("<value>");
        returnValue.append(this.getValue());
        returnValue.append("</value>");
        returnValue.append("</indexpoint>");
        return returnValue.toString();
    }
}

