/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import java.util.ArrayList;
import java.util.Collections;
import jp.robotbrain.signal.EnabledDefaultSignal;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.JudgmentResult;
import jp.robotbrain.signal.NmSignal;
import jp.robotbrain.signal.Signal;
import jp.robotbrain.signal.SignalTagComparator;
import jp.robotbrain.signal.SimpleSignal;
import jp.robotbrain.signal.SummaryPriority;
import jp.robotbrain.signal.Tag;
import jp.robotbrain.signal.TypeSignalBlock;

@TypeSignalBlock
@EnabledDefaultSignal
@InputComponentList(values={"@Signal"})
public class SignalBlock
extends Signal {
    private final ArrayList<Signal> m_inputSignalList = new ArrayList();

    public SignalBlock(String p_label, int p_priority) {
        super(p_label, p_priority);
    }

    @Override
    public JudgmentResult getJudgmentResult() throws IndexStreamException {
        SummaryPriority sumPriority = this.getSummaryPriority();
        Tag inputTag = this.getInputTag();
        if (inputTag == null) {
            return new JudgmentResult(null, NmSignal.NOSIGNAL);
        }
        SimpleSignal max = sumPriority.getMaxSignal(inputTag);
        NmSignal returnValue = this.getDefaultSignal();
        if (max != null && max.getPriority() + sumPriority.getNeutral() >= 100) {
            returnValue = max.getJudgmentResult().getSignal();
        }
        this.setDetails(returnValue.toString());
        return new JudgmentResult(inputTag, returnValue);
    }

    protected Tag getInputTag() throws IndexStreamException {
        if (this.m_inputSignalList.size() <= 0) {
            return null;
        }
        Signal max = null;
        try {
            max = Collections.max(this.m_inputSignalList, new SignalTagComparator());
        }
        catch (ClassCastException e) {
            return null;
        }
        return max.getJudgmentResult().getTag();
    }

    public void addTradeSignal(Signal p_tradeSignal) {
        this.m_inputSignalList.add(p_tradeSignal);
    }

    @Override
    public String getDetails() {
        StringBuilder returnValue = new StringBuilder();
        for (Signal sig : this.m_inputSignalList) {
            returnValue.append(sig.getDetails());
        }
        returnValue.append(super.getDetails());
        return returnValue.toString();
    }

    private SummaryPriority getSummaryPriority() throws IndexStreamException {
        SummaryPriority returnValue = new SummaryPriority();
        for (Signal inputSignal : this.m_inputSignalList) {
            switch (inputSignal.getJudgmentResult().getSignal()) {
                case LONG: {
                    returnValue.addLong(inputSignal.getPriority());
                    break;
                }
                case SHORT: {
                    returnValue.addShort(inputSignal.getPriority());
                    break;
                }
                case REST: {
                    returnValue.addRest(inputSignal.getPriority());
                    break;
                }
                case NEUTRAL: {
                    returnValue.addNeutral(inputSignal.getPriority());
                }
            }
        }
        return returnValue;
    }
}

