/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.signal.EnabledOutputSignal;
import jp.robotbrain.signal.IndexLine;
import jp.robotbrain.signal.IndexPoint;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.IndexStreamPort;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.JudgmentResult;
import jp.robotbrain.signal.NmSignal;
import jp.robotbrain.signal.SignalStream;
import jp.robotbrain.signal.TypeSignalStream;

@TypeSignalStream
@EnabledOutputSignal
@InputComponentList(values={"@IndexLine"})
public class RiseSignal
extends SignalStream {
    private NmSignal m_prevSignal = NmSignal.NOSIGNAL;

    public RiseSignal(String p_label, int p_priority, NmSignal p_outputSignal) {
        super(p_label, p_priority, p_outputSignal);
        this.getPortList().add("@IndexLine");
    }

    @Override
    public JudgmentResult getJudgmentResult() throws IndexStreamException {
        IndexStreamPort p = this.getPortList().get("@IndexLine");
        if (p == null) {
            throw new IndexStreamException("Port Null Error");
        }
        if (p.getObjectList() == null) {
            return new JudgmentResult(null, NmSignal.NOSIGNAL);
        }
        if (!(p.getObjectList() instanceof IndexLine)) {
            throw new IndexStreamException("Instance Error");
        }
        IndexLine line = (IndexLine)p.getObjectList();
        if (line.size() < 2) {
            this.setDetails(NmSignal.NOSIGNAL.toString());
            return new JudgmentResult(null, NmSignal.NOSIGNAL);
        }
        NmSignal returnValue = NmSignal.NOSIGNAL;
        if (((IndexPoint)line.getLast()).getValue() > ((IndexPoint)line.getPrev(1)).getValue()) {
            this.m_prevSignal = returnValue = this.getOutputSignal();
        } else if (((IndexPoint)line.getLast()).getValue() == ((IndexPoint)line.getPrev(1)).getValue()) {
            returnValue = this.m_prevSignal;
        } else {
            this.m_prevSignal = NmSignal.NOSIGNAL;
        }
        this.setDetails(returnValue.toString());
        return new JudgmentResult(((IndexPoint)line.getLast()).getTag(), returnValue);
    }
}

