/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.signal.EnabledDefaultSignal;
import jp.robotbrain.signal.EnabledOutputSignal;
import jp.robotbrain.signal.IndexLine;
import jp.robotbrain.signal.IndexPoint;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.IndexStreamPort;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.JudgmentResult;
import jp.robotbrain.signal.NmSignal;
import jp.robotbrain.signal.SignalStream;
import jp.robotbrain.signal.TypeSignalStream;

@TypeSignalStream
@EnabledDefaultSignal
@EnabledOutputSignal
@InputComponentList(values={"baseLine@IndexLine", "*upperRange@IndexLine", "*lowerRange@IndexLine", "moveLine@IndexLine"})
public class InnerRangeSignal
extends SignalStream {
    public InnerRangeSignal(String p_label, int p_priority, NmSignal p_outputSignal) {
        super(p_label, p_priority, p_outputSignal);
        this.getPortList().add("baseLine@IndexLine");
        this.getPortList().add("*upperRange@IndexLine");
        this.getPortList().add("*lowerRange@IndexLine");
        this.getPortList().add("moveLine@IndexLine");
    }

    @Override
    public JudgmentResult getJudgmentResult() throws IndexStreamException {
        double moveValue;
        IndexStreamPort base = this.getPortList().get("baseLine@IndexLine");
        IndexStreamPort upper = this.getPortList().get("*upperRange@IndexLine");
        IndexStreamPort lower = this.getPortList().get("*lowerRange@IndexLine");
        IndexStreamPort move = this.getPortList().get("moveLine@IndexLine");
        if (base == null) {
            throw new IndexStreamException("baseLine@IndexLine Port Null Error");
        }
        if (upper == null) {
            throw new IndexStreamException("*upperRange@IndexLine Port Null Error");
        }
        if (lower == null) {
            throw new IndexStreamException("*lowerRange@IndexLine Port Null Error");
        }
        if (move == null) {
            throw new IndexStreamException("moveLine@IndexLine Port Null Error");
        }
        if (base.getObjectList() == null) {
            return new JudgmentResult(null, NmSignal.NOSIGNAL);
        }
        if (move.getObjectList() == null) {
            return new JudgmentResult(null, NmSignal.NOSIGNAL);
        }
        if (!(base.getObjectList() instanceof IndexLine)) {
            throw new IndexStreamException("baseLine@IndexLine Instance Error");
        }
        if (!(move.getObjectList() instanceof IndexLine)) {
            throw new IndexStreamException("moveLine@IndexLine Instance Error");
        }
        IndexLine baseLine = (IndexLine)base.getObjectList();
        if (baseLine.size() < 1) {
            this.setDetails(NmSignal.NOSIGNAL.toString());
            return new JudgmentResult(null, NmSignal.NOSIGNAL);
        }
        IndexLine moveLine = (IndexLine)move.getObjectList();
        if (moveLine.size() < 1) {
            this.setDetails(NmSignal.NOSIGNAL.toString());
            return new JudgmentResult(null, NmSignal.NOSIGNAL);
        }
        IndexLine upperLine = null;
        if (upper.getObjectList() != null) {
            if (!(upper.getObjectList() instanceof IndexLine)) {
                throw new IndexStreamException("*upperRange@IndexLine Instance Error");
            }
            upperLine = (IndexLine)upper.getObjectList();
            if (upperLine.size() < 1) {
                this.setDetails(NmSignal.NOSIGNAL.toString());
                return new JudgmentResult(null, NmSignal.NOSIGNAL);
            }
        }
        IndexLine lowerLine = null;
        if (lower.getObjectList() != null) {
            if (!(lower.getObjectList() instanceof IndexLine)) {
                throw new IndexStreamException("*lowerRange@IndexLine Instance Error");
            }
            lowerLine = (IndexLine)lower.getObjectList();
            if (lowerLine.size() < 1) {
                this.setDetails(NmSignal.NOSIGNAL.toString());
                return new JudgmentResult(null, NmSignal.NOSIGNAL);
            }
        }
        NmSignal returnValue = NmSignal.NOSIGNAL;
        double baseValue = ((IndexPoint)baseLine.getLast()).getValue();
        double upperValue = 0.0;
        if (upperLine != null) {
            upperValue = ((IndexPoint)upperLine.getLast()).getValue();
        }
        double lowerValue = 0.0;
        if (lowerLine != null) {
            lowerValue = ((IndexPoint)lowerLine.getLast()).getValue();
        }
        returnValue = (moveValue = ((IndexPoint)moveLine.getLast()).getValue()) <= baseValue + upperValue && moveValue >= baseValue - lowerValue ? this.getOutputSignal() : this.getDefaultSignal();
        this.setDetails(returnValue.toString());
        return new JudgmentResult(((IndexPoint)moveLine.getLast()).getTag(), returnValue);
    }
}

