/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.CandleStickList;
import jp.robotbrain.signal.DmiList;
import jp.robotbrain.signal.IndexObjectList;
import jp.robotbrain.signal.IndexStream;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.TypeIndexStream;

@TypeIndexStream(value="DmiList")
@InputComponentList(values={"@CandleStickList"})
@GeneDefaultLabelList(values={"ccount"})
public class DmiListStream
extends IndexStream {
    private static final long serialVersionUID = 1L;
    private final DmiList m_dmiList;

    public DmiListStream(String p_label, GeneList p_geneList, String p_ccountLabel) throws GeneListException {
        super(p_label);
        Gene ccountGene = p_geneList.getGene(p_ccountLabel);
        int ccount = ccountGene.getIntValue();
        this.m_dmiList = new DmiList(ccount);
    }

    public void enter(CandleStickList p_src) throws IndexStreamException {
        this.notifyIndex(p_src);
    }

    @Override
    public void notifyIndex(IndexObjectList<?> p_indexObjectList) throws IndexStreamException {
        if (p_indexObjectList == null) {
            throw new IndexStreamException("Null Error");
        }
        if (!(p_indexObjectList instanceof CandleStickList)) {
            throw new IndexStreamException("Instance Error");
        }
        if (p_indexObjectList.size() <= 0) {
            return;
        }
        int prevSize = this.m_dmiList.size();
        this.m_dmiList.addObject((CandleStickList)p_indexObjectList);
        if (this.m_dmiList.size() > prevSize) {
            this.notifyIndexNext(this.m_dmiList);
        }
    }

    public DmiList getValues() {
        return this.m_dmiList;
    }
}

