/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.IndexLine;
import jp.robotbrain.signal.IndexObjectList;
import jp.robotbrain.signal.IndexPoint;
import jp.robotbrain.signal.IndexStream;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.LevelDesign;
import jp.robotbrain.signal.LevelDesignList;
import jp.robotbrain.signal.LevelLine;
import jp.robotbrain.signal.TypeIndexStream;

@TypeIndexStream(value="LevelLine")
@InputComponentList(values={"@IndexLine"})
@GeneDefaultLabelList(values={"levelLabelList..."})
public class LevelLineStream
extends IndexStream {
    private static final long serialVersionUID = 1L;
    private final LevelLine m_levelLine;

    public LevelLineStream(String p_label, GeneList p_geneList, String ... p_levelLabelList) throws GeneListException {
        super(p_label);
        if (p_levelLabelList == null) {
            throw new GeneListException("p_levelLabelList is null");
        }
        LevelDesignList levelDesignList = new LevelDesignList();
        int level = 0;
        double prevValue = 0.0;
        String[] stringArray = p_levelLabelList;
        int n = p_levelLabelList.length;
        int n2 = 0;
        while (n2 < n) {
            String levelLabel = stringArray[n2];
            Gene levelLabelGene = null;
            if (level == 0) {
                levelLabelGene = p_geneList.getGene(levelLabel);
                levelDesignList.addLevelDesign(new LevelDesign(level, Double.NEGATIVE_INFINITY, levelLabelGene.getDoubleValue()));
            } else {
                levelLabelGene = p_geneList.getGene(levelLabel);
                levelDesignList.addLevelDesign(new LevelDesign(level, prevValue, levelLabelGene.getDoubleValue()));
            }
            ++level;
            prevValue = levelLabelGene.getDoubleValue();
            ++n2;
        }
        this.m_levelLine = new LevelLine();
        this.m_levelLine.setLevelDesignList(levelDesignList);
    }

    public void enter(IndexLine p_src) throws IndexStreamException {
        this.notifyIndex(p_src);
    }

    @Override
    public void notifyIndex(IndexObjectList<?> p_indexObjectList) throws IndexStreamException {
        if (p_indexObjectList == null) {
            throw new IndexStreamException("Null Error");
        }
        if (!(p_indexObjectList instanceof IndexLine)) {
            throw new IndexStreamException("Instance Error");
        }
        if (p_indexObjectList.size() <= 0) {
            return;
        }
        int prevSize = this.m_levelLine.size();
        this.m_levelLine.addPoint((IndexPoint)p_indexObjectList.getLast());
        if (this.m_levelLine.size() > prevSize) {
            this.notifyIndexNext(this.m_levelLine);
        }
    }

    public LevelLine getValues() {
        return this.m_levelLine;
    }
}

