/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import java.io.Serializable;
import java.util.ArrayList;
import jp.robotbrain.signal.IndexObjectList;
import jp.robotbrain.signal.IndexStreamDestination;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.TradeComponent;

public abstract class IndexStream
extends TradeComponent
implements Serializable,
IndexStreamDestination {
    private static final long serialVersionUID = 1L;
    private final ArrayList<IndexStreamDestination> m_destinationList = new ArrayList();

    public IndexStream(String p_label) {
        super(p_label);
    }

    @Override
    public abstract void notifyIndex(IndexObjectList<?> var1) throws IndexStreamException;

    protected final void notifyIndexNext(IndexObjectList<?> p_indexObjectList) throws IndexStreamException {
        for (IndexStreamDestination i : this.m_destinationList) {
            if (i == null) continue;
            i.notifyIndex(p_indexObjectList);
        }
    }

    public abstract IndexObjectList<?> getValues();

    public final void addDestination(IndexStreamDestination p_indexStream) {
        this.m_destinationList.add(p_indexStream);
    }

    public final String toXml() {
        if (this.getValues().size() <= 0) {
            return "";
        }
        StringBuilder returnValue = new StringBuilder();
        returnValue.append("<component label=\"");
        returnValue.append(this.getLabel());
        returnValue.append("\">");
        returnValue.append(this.getValues().toXml());
        returnValue.append("</component>");
        return returnValue.toString();
    }
}

