/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.framework;

import java.io.Serializable;
import jp.robotbrain.framework.UtilFramework;

public final class Gene
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private String m_label;
    private double m_min;
    private double m_max;
    private double m_step;
    private double m_value;
    private int m_scale;
    private boolean m_optimize;

    public void initRandom() {
        int valueCount = (int)((this.getMax() - this.getMin()) / this.getStep());
        this.setDoubleValue(this.getMin() + this.getStep() * (double)UtilFramework.random(valueCount));
    }

    public boolean equals(Object p_other) {
        if (p_other == null) {
            return false;
        }
        if (this.getLabel() == null) {
            return false;
        }
        if (p_other instanceof Gene) {
            Gene other = (Gene)p_other;
            return this.getLabel().equals(other.getLabel());
        }
        return false;
    }

    public int hashCode() {
        return this.getLabel().hashCode();
    }

    public Object clone() {
        Gene destg = new Gene();
        destg.setLabel(this.getLabel());
        destg.setDoubleValue(this.getDoubleValue());
        destg.setMax(this.getMax());
        destg.setMin(this.getMin());
        destg.setStep(this.getStep());
        destg.setScale(this.getScale());
        destg.setOptimize(this.isOptimize());
        return destg;
    }

    protected void copyDesign(Gene p_src) {
        this.setMax(p_src.getMax());
        this.setMin(p_src.getMin());
        this.setStep(p_src.getStep());
        this.setScale(p_src.getScale());
        this.setOptimize(p_src.isOptimize());
    }

    public String getStatus() {
        String returnValue = this.getLabel();
        returnValue = String.valueOf(returnValue) + ",optimize=" + this.isOptimize();
        double j = this.getMin();
        while (UtilFramework.roundDouble(j, this.getScale()) <= this.getMax()) {
            returnValue = String.valueOf(returnValue) + ",";
            double listvalue = UtilFramework.roundDouble(j, this.getScale());
            if (listvalue == this.getDoubleValue()) {
                returnValue = String.valueOf(returnValue) + "(";
            }
            returnValue = String.valueOf(returnValue) + UtilFramework.formatDouble(listvalue, this.getScale());
            if (listvalue == this.getDoubleValue()) {
                returnValue = String.valueOf(returnValue) + ")";
            }
            j = UtilFramework.roundDouble(j + this.getStep(), this.getScale());
        }
        return returnValue;
    }

    public void setLabel(String p_label) {
        this.m_label = p_label;
    }

    public String getLabel() {
        return this.m_label;
    }

    public void setMax(double p_max) {
        this.m_max = p_max;
    }

    public double getMax() {
        return UtilFramework.roundDouble(this.m_max, this.m_scale);
    }

    public void setMin(double p_min) {
        this.m_min = p_min;
    }

    public double getMin() {
        return UtilFramework.roundDouble(this.m_min, this.m_scale);
    }

    public void setDoubleValue(double p_value) {
        this.m_value = p_value;
    }

    public double getDoubleValue() {
        return UtilFramework.roundDouble(this.m_value, this.m_scale);
    }

    public int getIntValue() {
        return (int)this.m_value;
    }

    public void setStep(double p_step) {
        this.m_step = p_step;
    }

    public double getStep() {
        return UtilFramework.roundDouble(this.m_step, this.m_scale);
    }

    public void setScale(int p_scale) {
        this.m_scale = p_scale;
    }

    public int getScale() {
        return this.m_scale;
    }

    public void setOptimize(boolean p_optimize) {
        this.m_optimize = p_optimize;
    }

    public boolean isOptimize() {
        return this.m_optimize;
    }
}

