/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Xml {
    private final DocumentBuilderFactory m_factory;
    private final DocumentBuilder m_builder;
    private Document m_document;
    private Element m_rootElement;
    private final String m_rootElementName;

    private Xml(String p_rootElementName) throws ParserConfigurationException {
        this.m_rootElementName = p_rootElementName;
        this.m_factory = DocumentBuilderFactory.newInstance();
        this.m_builder = this.m_factory.newDocumentBuilder();
    }

    public static Xml createByInputStream(String p_rootElementName, InputStream p_inputStream) throws ParserConfigurationException, SAXException, IOException {
        Xml returnValue = new Xml(p_rootElementName);
        returnValue.m_document = returnValue.m_builder.parse(p_inputStream);
        returnValue.m_rootElement = returnValue.m_document.getDocumentElement();
        returnValue.setIdAttribute();
        return returnValue;
    }

    public static Xml createByFile(String p_rootElementName, String p_filePath) throws ParserConfigurationException, SAXException, IOException {
        Xml returnValue = new Xml(p_rootElementName);
        File f = new File(p_filePath);
        if (f.exists()) {
            returnValue.m_document = returnValue.m_builder.parse(f);
            returnValue.m_rootElement = returnValue.m_document.getDocumentElement();
        } else {
            returnValue.createNewXML();
        }
        returnValue.setIdAttribute();
        return returnValue;
    }

    protected void setIdAttribute() {
    }

    private final void createNewXML() {
        DOMImplementation domImpl = this.m_builder.getDOMImplementation();
        this.m_document = domImpl.createDocument("", this.m_rootElementName, null);
        this.m_rootElement = this.m_document.getDocumentElement();
    }

    public final void clear() {
        this.m_builder.reset();
        this.createNewXML();
    }

    public final void save(String p_filePath) throws TransformerException, IOException {
        TransformerFactory tft = TransformerFactory.newInstance();
        Transformer tf = tft.newTransformer();
        DOMSource src = new DOMSource();
        src.setNode(this.m_document);
        StreamResult sr = new StreamResult();
        FileOutputStream f = new FileOutputStream(p_filePath);
        sr.setOutputStream(f);
        tf.transform(src, sr);
        f.close();
    }

    public final boolean isExistElement(Element p_parentElement, String p_tagName) {
        NodeList nodeList = p_parentElement.getElementsByTagName(p_tagName);
        if (nodeList == null) {
            return false;
        }
        Element returnValue = (Element)nodeList.item(0);
        return returnValue != null;
    }

    public final Element getElement(Element p_parentElement, String p_tagName) {
        NodeList nodeList = p_parentElement.getElementsByTagName(p_tagName);
        if (nodeList == null) {
            throw new RuntimeException("Error getElement NodeList :" + p_tagName);
        }
        Element returnValue = (Element)nodeList.item(0);
        if (returnValue == null) {
            throw new RuntimeException("Error getElement Element :" + p_tagName);
        }
        return returnValue;
    }

    public final ArrayList<Element> getElementList(Element p_parentElement, String p_tagName) {
        NodeList nodeList = p_parentElement.getElementsByTagName(p_tagName);
        if (nodeList == null) {
            throw new RuntimeException("Error getElementList NodeList :" + p_tagName);
        }
        ArrayList<Element> returnValue = new ArrayList<Element>();
        int i = 0;
        while (i < nodeList.getLength()) {
            Element e = (Element)nodeList.item(i);
            if (e == null) {
                throw new RuntimeException("Error getElementList Element :" + p_tagName);
            }
            returnValue.add(e);
            ++i;
        }
        return returnValue;
    }

    public final String getValue(Element p_parentElement, String p_tagName) {
        Element elChild = this.getElement(p_parentElement, p_tagName);
        Node ndChild = elChild.getFirstChild();
        if (ndChild == null) {
            throw new RuntimeException("Error getValue Node :" + p_tagName);
        }
        return ndChild.getNodeValue();
    }

    public final void setValue(Element p_parentElement, String p_tagName, String p_value) {
        Element elChild;
        NodeList nodeList = p_parentElement.getElementsByTagName(p_tagName);
        if (nodeList.getLength() <= 0) {
            elChild = this.createValue(p_parentElement, p_tagName, p_value);
        } else {
            elChild = (Element)nodeList.item(0);
            if (elChild == null) {
                throw new RuntimeException("Error setValue Element :" + p_tagName);
            }
        }
        Node ndChild = elChild.getFirstChild();
        if (ndChild == null) {
            throw new RuntimeException("Error setValue Node :" + p_tagName);
        }
        ndChild.setNodeValue(p_value);
    }

    public final ArrayList<String> getValueList(Element p_parentElement, String p_tagName) {
        ArrayList<String> returnValue = new ArrayList<String>();
        NodeList nodelist = p_parentElement.getElementsByTagName(p_tagName);
        if (nodelist == null) {
            throw new RuntimeException("Error getValueList NodeList :" + p_tagName);
        }
        int i = 0;
        while (i < nodelist.getLength()) {
            Element elChild = (Element)nodelist.item(i);
            if (elChild == null) {
                throw new RuntimeException("Error getValueList Element :" + p_tagName);
            }
            Node ndChild = elChild.getFirstChild();
            if (ndChild == null) {
                throw new RuntimeException("Error getValueList Node :" + p_tagName);
            }
            returnValue.add(ndChild.getNodeValue());
            ++i;
        }
        return returnValue;
    }

    public final void setValueList(Element p_parentElement, String p_tagName, ArrayList<String> p_valueList) {
        NodeList nodelist = p_parentElement.getElementsByTagName(p_tagName);
        if (nodelist == null) {
            throw new RuntimeException("Error setValueList NodeList :" + p_tagName);
        }
        ArrayList<Node> removelist = new ArrayList<Node>();
        int i = 0;
        while (i < nodelist.getLength()) {
            removelist.add(nodelist.item(i));
            ++i;
        }
        i = 0;
        while (i < removelist.size()) {
            Node child = (Node)removelist.get(i);
            if (child == null) {
                throw new RuntimeException("Error setValueList Element :" + p_tagName);
            }
            p_parentElement.removeChild(child);
            ++i;
        }
        for (String s : p_valueList) {
            this.createValue(p_parentElement, p_tagName, s);
        }
    }

    public final Element createElement(Element p_parentElement, String p_tagName) {
        Element returnValue = this.m_document.createElement(p_tagName);
        p_parentElement.appendChild(returnValue);
        return returnValue;
    }

    private final Element createValue(Element p_parentElement, String p_tagName, String p_value) {
        Element e = this.createElement(p_parentElement, p_tagName);
        e.appendChild(this.m_document.createTextNode(p_value));
        return e;
    }

    public final Element getRootElement() {
        return this.m_rootElement;
    }
}

