/*
 * Copyright 2006 Robbie.JP
 */
package robbie.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * ProxyCX^X𐶐t@NgNX.<p>
 * @since 1.1.1
 */
public class ProxyFactory {
    
    private static Log LOG = LogFactory.getLog(ProxyFactory.class);

    /**
     * ProxyCX^X𐶐܂B<p>
     * @param loader NX[_
     * @param interfaces C^tF[X̔z
     * @param handler InvocationHandler̎NX
     * @return ꂽProxyCX^X
     */
    public static Object createProxy(
            ClassLoader loader, 
            Class[] interfaces, 
            InvocationHandler handler) {
        
        Object proxy = null;
        try {
            proxy = Proxy.newProxyInstance(loader, interfaces, handler);
        } catch(Exception ex) {
            LOG.warn("ProxyCX^X̐ɗOcatch܂B",ex);
        }
        return proxy;
    }
    
    /**
     * ProxyCX^X𐶐܂B<p>
     * @param interfaces C^tF[X̔z
     * @param handler InvocationHandler̎NX
     * @return ꂽProxyCX^X
     */
    public static Object createProxy(Class[] interfaces, InvocationHandler handler) {
        return createProxy(
                Thread.currentThread().getContextClassLoader(), 
                interfaces,
                handler);
    }
    
    /**
     * PC^tF[XProxyCX^X𐶐܂B<p>
     * @param interfaceClass C^tF[X
     * @param handler InvocationHandler̎NX
     * @return ꂽProxyCX^X
     */
    public static Object createProxy(Class interfaceClass, InvocationHandler handler) {
        return createProxy(new Class[]{interfaceClass}, handler);
    }
}
