/*
 * Copyright 2004-2006 Robbie.JP
 */
package robbie.util;

import java.lang.reflect.Constructor;

/**
 * w肵NX̃CX^X𐶐t@NgNXB<p>
 * Ver1.0.2ȍ~́ARXgN^ɂΉ܂B
 */
public class InstanceFactory {

    /**
     * w肵NX̃CX^X𐶐B<p>
     * @param className 쐬CX^X̃NX
     * @return 쐬CX^X
     */
    public static Object createInstance(String className) {

        try {
            return ClassFactory.getClass(className).newInstance();
        } catch(Exception ex) {
            throw new InstanceCreateFailureException("InstanceFactory::createInstance() failed", ex);
        }
    }

    /**
     * w肵NX̃CX^Xw肵NX[_ŐB<p>
     * @param className 쐬CX^X̃NX
     * @param loader NX[_
     * @return 쐬CX^X
     */
    public static Object createInstance(String className, ClassLoader loader) {
 
        try {
            if (loader == null) {
                return createInstance(className);
            }
            return ClassFactory.getClass(className, loader).newInstance();
        } catch (Exception ex) {
            if(ex instanceof InstanceCreateFailureException) {
                throw (InstanceCreateFailureException)ex;
            }
            throw new InstanceCreateFailureException("InstanceFactory::createInstance() failed", ex);
        }
    }
    
    /**
     * w肵NX̃CX^X𐶐B<p>
     * @param className 쐬CX^X̃NX
     * @param args RXgN^̈
     * @return 쐬CX^X
     * @since 1.0.2
     */
    public static Object createInstance(String className, Object[] args) {
        
        try {
            return createInstance(ClassFactory.getClass(className), args);
        } catch(Exception ex) {
            if (ex instanceof InstanceCreateFailureException) {
                throw (InstanceCreateFailureException)ex;
            }
            throw new InstanceCreateFailureException("InstanceFactory::createInstance() failed", ex);
        }
    }
    
    /**
     * w肵NX̃CX^Xw肵NX[_ŐB<p>
     * @param className 쐬CX^X̃NX
     * @param args RXgN^̈
     * @param loader NX[_
     * @return 쐬CX^X
     * @since 1.0.2
     */
    public static Object createInstance(String className, Object[] args, ClassLoader loader) {
        
        try {
            if (loader == null) {
                return createInstance(className, args);
            }
            Class objClass = Class.forName(className, true, loader);
            return createInstance(objClass, args);
        } catch (Exception ex) {
            if(ex instanceof InstanceCreateFailureException) {
                throw (InstanceCreateFailureException)ex;
            }
            throw new InstanceCreateFailureException("InstanceFactory::createInstance() failed", ex);
        }
    }
    
    /**
     * w肵NX̃CX^X𐶐B<p>
     * @param classObj 쐬CX^X̃NXIuWFNg
     * @return 쐬CX^X
     */
    public static Object createInstance(Class classObj) {

        try {
            return classObj.newInstance();
        } catch(Exception ex) {
            throw new InstanceCreateFailureException("InstanceFactory::createInstance() failed", ex);
        }
    }

    /**
     * w肵NX̃CX^X𐶐B<p>
     * @param objClass 쐬CX^X̃NXIuWFNg
     * @param args RXgN^̈
     * @return 쐬CX^X
     * @since 1.0.2
     */
    public static Object createInstance(Class objClass, Object[] args) {
        
        try {
            Class[] argClasses = new Class[args.length];
            for (int i=0; i<args.length; i++) {
                argClasses[i] = args[i].getClass();
            }
            Constructor con = objClass.getConstructor(argClasses);
            return con.newInstance(args);
        } catch(Exception ex) {
            throw new InstanceCreateFailureException("InstanceFactory::createInstance() failed", ex);
        }
        
    }
}
