/*
 * Copyright 2006 Robbie.JP
 */
package robbie.dao.x;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Text;

import robbie.dao.DaoKeys;
import robbie.dao.DaoTypes;

/**
 * XQueryXMLvf͂̃[eBeBNXB<p>
 * Ver1.2܂łXQueryɎĂ\bhAVer1.3.0ȍ~static\bhƂĕ܂B
 * @since 1.3.0
 */
public class XQueryParseUtil {
    
    private XQueryParseUtil() {}
    
    /**
     * &lt;query&gt;A&lt;subquery&gt;A&lt;case&gt;A&lt;default&gt;vfSQL𐶐B<p>
     * <pre>
     * queryAswitchAlistAwhereAvarArepeatAbetweenvfACDATALq\łB
     * eLXgLȂ̂́AqueryAcase(default)Asubqueryvf
     * ̃Reĉ݂łB
     * ̑whereAswitchAlistvfł́AeLXg͋܂B
     * ܂A̋tqueryAcase(default)Asubqueryvf̒łconstvf͎gpo܂B
     * constvfwherelistvfł̂ݎgpł܂B
     * </pre>
     * @param ele vfIuWFNg
     * @param params ̓p[^Map
     * @param paramsMapList oChϐList
     * @return SQL(LSQL񂪐łȂꍇɂnull)
     */
    public static StringBuffer handleQueryElement(Element ele, Map params, List paramsMapList) {
        
        StringBuffer sqlStrBuff = new StringBuffer();
        List children = ele.getContent();
        for (Iterator it=children.iterator(); it.hasNext(); ) {
            Object obj = it.next();
            
            // ̏
            if (obj instanceof String) {
                sqlStrBuff.append((String)obj);
                continue;
            }
            // Text̏iJDOM 1.0 Ήj
            if (obj instanceof Text) {
                sqlStrBuff.append(((Text)obj).getText());
                continue;
            }
            
            // Element̏
            StringBuffer tmpBuff = null;
            Element child = (Element)obj;
            if (child.getName().equals("var")) {
                tmpBuff =  handleVarElement(child, params, paramsMapList);
            } else if (child.getName().equals("repeat")) { 
                tmpBuff =  handleRepeatElement(child, params, paramsMapList);
            } else if (child.getName().equals("between")) { 
                tmpBuff =  handleBetweenElement(child, params, paramsMapList);
            } else if (child.getName().equals("switch")) {
                tmpBuff =  handleSwitchElement(child, params, paramsMapList);
            } else if (child.getName().equals("list")) {
                tmpBuff =  handleListElement(child, params, paramsMapList);
            } else if (child.getName().equals("where")) {
                tmpBuff =  handleWhereElement(child, params, paramsMapList);
            } else {
                throw new XQueryParseFailureException("vf܂." +
                        " element=" + ele.getName());
            }
            
            if (tmpBuff != null) {
                sqlStrBuff.append(tmpBuff);
            }
        }
        if (XQueryParseUtil.isSpaceOnly(sqlStrBuff.toString())) {
            return null;
        }
        return sqlStrBuff;
    }
    
    /**
     * &lt;const&gt;vfSQL𐶐B<p>
     * <pre>
     * ̗vf́AvarArepeatAbetweenƓlleafi}̐[jƂȂvfłB
     * qvf݂͑܂B
     * ܂AconstvfwherevfA܂listvfł̂ݎwł܂B
     * </pre>
     * @param ele vfIuWFNg
     * @param params ̓p[^Map
     * @param paramsMapList oChϐList
     * @return SQL(񂪐łȂꍇɂnull)
     */
    public static StringBuffer handleConstElement(Element ele, Map params, List paramsMapList) {
        
        String reqStr = ele.getAttributeValue("req");
        if (reqStr != null) {
            Boolean isRequired = Boolean.valueOf(reqStr);
            String keyStr = ele.getAttributeValue("key");
            if (isRequired.booleanValue()) {
                if(keyStr == null || keyStr.length() == 0 || !params.containsKey(keyStr)) {
                    // key݂ȂA܂͒l͂ĂȂB
                    throw new XQueryParseFailureException("reqvf݂̂Ƀp[^Mapɒl݂܂." +
                            " element=" + ele.getName() +
                            " req=" + reqStr +
                            " key=" + keyStr);
                }
            } else {
                if (keyStr == null || keyStr.length() == 0 || !params.containsKey(keyStr)) {
                    // K{łȂMapKey܂܂Ȃꍇɂ͓WJȂ
                    return null;
                }
            }
        }
        String sqlStr = ele.getText();
        if (XQueryParseUtil.isSpaceOnly(sqlStr)) {
            return null;
        }
        return new StringBuffer(sqlStr);
    }
    
    /**
     * &lt;var&gt;vfSQL𐶐B<p>
     * <pre>
     * varvfɂ́Ap[^ɑΉoChϐuHv
     * ܂ރeLXgł邱Ƃz肳Ă܂B
     * qvfꍇɂ͖܂B
     * ܂Ap[^݂Ȃꍇɂ̗͂vf݂̑
     * 邽߁AISQL쐬ꍇɂvarvf
     * whereAlistvf𗘗pSQL`܂B
     * </pre>
     * @param ele vfIuWFNg
     * @param params ̓p[^Map
     * @param paramsMapList oChϐList
     * @return@SQL(񂪐łȂꍇɂnull)
     */
    public static StringBuffer handleVarElement(Element ele, Map params, List paramsMapList) {
        
        String keyStr = ele.getAttributeValue("key");
        if(keyStr == null) {
            // key݂ȂA܂͒l͂ĂȂB
            throw new XQueryParseFailureException("key݂܂." +
                    " element=" + ele.getName());
        }
        // lMapɓĂ邩H
        if(params == null || !params.containsKey(keyStr)) {
            if(ele.getAttributeValue("req") == null) {
                // req݂ȂA܂͒l͂ĂȂB
                throw new XQueryParseFailureException("varvfreq݂܂." +
                        " element=" + ele.getName());
            }
            // (ĂȂ)̃p[^͕K{H
            Boolean isRequired = Boolean.valueOf(ele.getAttributeValue("req"));
            if (isRequired.booleanValue()) {
                throw new XQueryParseFailureException(
                    " varvfreqtrueȂ̂Ƀp[^Mapɑ݂܂." +
                    " key=" + keyStr);
            }
            // K{łȂΉȂ
            return null;
        } 
        
        String typeStr = ele.getAttributeValue("type");
        Object valueObj = params.get(keyStr);
        if (valueObj != null && valueObj.getClass().isArray()) {
            // p[^z̏ꍇɂ́A
            // ڂ̒lZbgB
            valueObj = ((Object[])valueObj)[0];
        }
        if (ele.getAttribute("like") != null) {
            valueObj = handleLikeAttribute(ele.getAttributeValue("like"), valueObj);
        }
        Map parameterMap = new HashMap();
        parameterMap.put(DaoKeys.VALUE_KEY, valueObj);
        parameterMap.put(DaoKeys.TYPE_KEY, DaoTypes.getSQLType(typeStr));
        paramsMapList.add(parameterMap);
        return new StringBuffer(ele.getText());
    }

    /**
     * &lt;repeat&gt;vfSQL𐶐B<p>
     * <pre>
     * {IrepeatvfINq̃f[^WJƂ݂̂Ɏgp܂B
     * ȊO̎gpɂĂ͑z肵Ă܂̂ŒӂĂB
     * ܂Avarvfreqtrueł鎞ƓlɃp[^݂Ȃ
     * G[Ƃ܂B
     * </pre>
     * @param ele vfIuWFNg
     * @param params ̓p[^Map
     * @param paramsMapList oChϐList
     * @return@SQL(񂪐łȂꍇɂnull)
     */
    public static StringBuffer handleRepeatElement(Element ele, Map params, List paramsMapList) {
        
        String keyStr = ele.getAttributeValue("key");
        if(keyStr == null) {
            //@key݂ȂA܂͒l͂ĂȂB
            throw new XQueryParseFailureException("repeatvfkey݂܂." +
                    " element=" + ele.getName());
        }
        // lMapɓĂ邩H
        if(params == null || !params.containsKey(keyStr)) {
            if(ele.getAttributeValue("req") == null) {
                // req݂ȂA܂͒l͂ĂȂB
                throw new XQueryParseFailureException("repeatvfreq݂܂." +
                        " element=" + ele.getName());
            }
            // (ĂȂ)̃p[^͕K{H
            Boolean isRequired = Boolean.valueOf(ele.getAttributeValue("req"));
            if (isRequired.booleanValue()) {
                throw new XQueryParseFailureException(
                        " repeatvfreqtrueȂ̂Ƀp[^Mapɑ݂܂." +
                        " key=" + keyStr);
            }
            // K{łȂΉȂ
            return null;
        } 
        StringBuffer sqlStrBuf = null;
        String typeStr = ele.getAttributeValue("type");
        Object valueObj = params.get(keyStr);
        if (valueObj.getClass().isArray()) {
            // Zbglzłꍇɂ́A
            // ̒l̐ZbgB
            Object[] valueArray = (Object[])valueObj;
            if (valueArray.length == 0) {
                // lȂnull
                return null;
            }
            StringBuffer bindStr = new StringBuffer();
            for(int i=0; i<valueArray.length; i++) {
                // Zbgl̐AoChϐ̃eLXgύXB
                if (i > 0) {
                    bindStr.append(", ?");
                } else {
                    bindStr.append("?");
                }
                Object setValue = valueArray[i];
                if (ele.getAttribute("like") != null) {
                    setValue = handleLikeAttribute(ele.getAttributeValue("like"), setValue);
                }
                Map parameterMap = new HashMap();
                parameterMap.put(DaoKeys.VALUE_KEY, setValue);
                parameterMap.put(DaoKeys.TYPE_KEY, DaoTypes.getSQLType(typeStr));
                paramsMapList.add(parameterMap);
            }
            // oChϐvCX
            // ł̓eLXg̒ňoChϐ݂邱Ƃz肵ĂB
            sqlStrBuf = new StringBuffer(ele.getText().replaceFirst("[?]", bindStr.toString()));
        } else {
            sqlStrBuf = handleVarElement(ele, params, paramsMapList);
        }
        return sqlStrBuf;
    }
    
    /**
     * &lt;between&gt;vfSQL𐶐B<p>
     * <pre>
     * betweenvfSQLBETWEEN̂悤ɁAQZbgŎw肷Kv
     * ꍇɗp܂B]āAvarƈĂQKEY̑݃`FbN
     * sȂKv܂B
     * ܂A֋XbetweenƂOɂŁAbetweenɂgȂł
     * ܂B  
     * </pre>
     * @param ele vfIuWFNg
     * @param params ̓p[^Map
     * @param paramsMapList oChϐList
     * @return SQL(񂪐łȂꍇɂnull)
     */
    public static StringBuffer handleBetweenElement(Element ele, Map params, List paramsMapList) {
        
        String fromKey = ele.getAttributeValue("from");
        if(fromKey == null) {
            // from݂ȂA܂͒l͂ĂȂB
            throw new XQueryParseFailureException("betweenvffrom݂܂." +
                    " element=" + ele.getName());
        }
        String toKey = ele.getAttributeValue("to");
        if(toKey == null) {
            // to݂ȂA܂͒l͂ĂȂB
            throw new XQueryParseFailureException("betweenvfto݂܂." +
                    " element=" + ele.getName());
        }
        if (params == null 
                || !params.containsKey(fromKey)
                || !params.containsKey(toKey)) {
            if(ele.getAttributeValue("req") == null) {
                // req݂ȂA܂͒l͂ĂȂB
                throw new XQueryParseFailureException("betweenvfreq݂܂." +
                        " element=" + ele.getName());
            }
            // (ĂȂ)̃p[^͕K{H
            Boolean isRequired = Boolean.valueOf(ele.getAttributeValue("req"));
            if (isRequired.booleanValue()) {
                throw new XQueryParseFailureException(
                        " repeatvfreqtrueȂ̂Ƀp[^Mapɑ݂܂." +
                        " from key=" + fromKey +
                        " to key=" + toKey);
            }
            // K{łȂΉȂ
            return null;
        }
        String sqlStr = null;
        Object valueFrom = params.get(fromKey);
        if (valueFrom != null && valueFrom.getClass().isArray()) {
            // zȂzCast
            valueFrom = ((Object[])valueFrom)[0];
        }
        Object valueTo = params.get(toKey);
        if (valueTo != null && valueTo.getClass().isArray()) {
            // zȂzCast
            valueTo = ((Object[])valueTo)[0];
        }
        // set from value
        Map parameterMap = new HashMap();
        parameterMap.put(DaoKeys.VALUE_KEY, valueFrom);
        parameterMap.put(DaoKeys.TYPE_KEY, null);
        paramsMapList.add(parameterMap);
        
        // set to value
        parameterMap = new HashMap();
        parameterMap.put(DaoKeys.VALUE_KEY, valueTo);
        parameterMap.put(DaoKeys.TYPE_KEY, null);
        paramsMapList.add(parameterMap);
        
        sqlStr = ele.getText();
        return new StringBuffer(sqlStr);
    }

    /**
     * &lt;switch&gt;vfSQL𐶐B<p>
     * <pre>
     * switchvfł́AcaseAdefault܂B
     * eLXg܂B
     * </pre>
     * @param ele vfIuWFNg
     * @param params ̓p[^Map
     * @param paramsMapList oChϐList
     * @return SQL(񂪐łȂꍇɂnull)
     */
    public static StringBuffer handleSwitchElement(Element ele, Map params, List paramsMapList) {
        
        String keyStr = ele.getAttributeValue("key");
        if (keyStr == null) {
            return null;
        }
        if (params != null && params.containsKey(keyStr)) {
            Object valueObj = params.get(keyStr);
            if (valueObj == null) {
                return null;
            }
            List children = ele.getChildren("case");
            for (Iterator it=children.iterator(); it.hasNext(); ) {
                Element child = (Element)it.next();
                if (((String)valueObj).equals(child.getAttributeValue("value"))) {
                    // v<case>̏
                    return handleQueryElement(child, params, paramsMapList);
                }
            }
        }
        // <default>݂Ȃꍇɂ́Anull
        Element defaultCase = ele.getChild("default");
        if (defaultCase == null) {
            return null;
        }
        // <default>̏
        return handleQueryElement(defaultCase, params, paramsMapList);
    }
    
    /**
     * &lt;list&gt;vfSQL𐶐B<p>
     * <pre>
     * listvfł́AeLXg͋܂B
     * ́AlistqElemenťʓm邽߂
     * @\邽߂łB
     * ]varArepeat, constAlistAswitchAsubquery̗vf
     * 󔒕݂̂Ac̗vf͖܂B
     * A󔒕ɑ΂ĂjoinŌ͍sȂ܂B
     * </pre>
     * @param ele vfIuWFNg
     * @param params ̓p[^Map
     * @param paramsMapList oChϐList
     * @return SQL(񂪐łȂꍇɂnull)
     */
    public static StringBuffer handleListElement(Element ele, Map params, List paramsMapList) {
        
        StringBuffer sqlStrBuff = new StringBuffer();
        String joinStr = " ";
        if (ele.getAttribute("join") != null) {
            joinStr = " " + ele.getAttributeValue("join") + " ";
        }
        boolean isFirstContent = true;
        List contents = ele.getContent();
        for (Iterator it = contents.iterator(); it.hasNext();) {
            Object obj = it.next();
            
            // ̏
            if (obj instanceof String && XQueryParseUtil.isSpaceOnly((String)obj)) {
                sqlStrBuff.append((String)obj);
                continue;
            }
            // Text̏iJDOM 1.0 Ήj
            if (obj instanceof Text && XQueryParseUtil.isSpaceOnly(((Text)obj).getText())) {
                sqlStrBuff.append(((Text)obj).getText());
                continue;
            }
            
            // Element̏
            if (obj instanceof Element) {
                StringBuffer eleStrBuf = null;
                String eleType = ((Element)obj).getName();
                if (eleType.equals("list")) {
                    eleStrBuf = handleListElement((Element)obj, params, paramsMapList);
                    if (eleStrBuf != null) {
                        StringBuffer buf = new StringBuffer();
                        buf.append(" ( ");
                        buf.append(eleStrBuf);
                        buf.append(" ) ");
                        eleStrBuf = buf;
                    }
                } else if (eleType.equals("switch")) {
                    eleStrBuf = handleSwitchElement((Element)obj, params, paramsMapList);
                    if (eleStrBuf != null) {
                        StringBuffer buf = new StringBuffer();
                        buf.append(" ( ");
                        buf.append(eleStrBuf);
                        buf.append(" ) ");
                        eleStrBuf = buf;
                    }
                } else if (eleType.equals("subquery")) {
                    eleStrBuf = handleQueryElement((Element)obj, params, paramsMapList);
                    if (eleStrBuf != null) {
                        StringBuffer buf = new StringBuffer();
                        buf.append(" ( ");
                        buf.append(eleStrBuf);
                        buf.append(" ) ");
                        eleStrBuf = buf;
                    }
                } else if (eleType.equals("const")) {
                    eleStrBuf = handleConstElement((Element)obj, params, paramsMapList);
                } else if (eleType.equals("var")) {
                    eleStrBuf = handleVarElement((Element)obj, params, paramsMapList);
                } else if (eleType.equals("repeat")) {
                    eleStrBuf = handleRepeatElement((Element)obj, params, paramsMapList);
                } else if (eleType.equals("between")) {
                    eleStrBuf = handleBetweenElement((Element)obj, params, paramsMapList);
                } else {
                    throw new XQueryParseFailureException("vf܂." +
                            " element=" + ((Element)obj).getName());
                }
                
                if (eleStrBuf != null) {
                    if (isFirstContent)  {
                        sqlStrBuff.append(" ").append(eleStrBuf);
                        isFirstContent = false;
                        continue;
                    }
                    sqlStrBuff.append(joinStr).append(eleStrBuf);
                }
            }
        }
        if (XQueryParseUtil.isSpaceOnly(sqlStrBuff.toString())) {
            return null;
        }
        return sqlStrBuff;
    }
    
    /**
     * &lt;where&gt;SQL𐶐B<p>
     * <pre>
     * listvfƂ̈Ⴂ́AjoinZbgĂȂ΁A
     * l"AND"joinZbg邱ƂƁAWHERE
     * 擪ɒǉ邱ƂłB
     * </pre>
     * @param ele vfIuWFNg
     * @param params ̓p[^Map
     * @param paramsMapList oChϐList
     * @return SQL
     */
    public static StringBuffer handleWhereElement(Element ele, Map params, List paramsMapList) {
        
        if (ele.getAttribute("join") == null) {
            Attribute attr = new Attribute("join", "AND");
            ele.setAttribute(attr);
        }
        StringBuffer sqlStrBuff = handleListElement(ele, params, paramsMapList);
        if (sqlStrBuff != null) {
            StringBuffer buf = new StringBuffer("WHERE ");
            buf.append(sqlStrBuff);
            sqlStrBuff = buf;
        }
        return sqlStrBuff;
    }
    
    /**
     * &lt;like&gt;ꍇɂ̓oChϐɃChJ[hǉB<p>
     * ϐStringł͂Ȃꍇɂ́AȂB
     * @param likeStr
     * @param valueObj
     * @return oChϐ
     */
    public static Object handleLikeAttribute(String likeStr, Object valueObj) {
        
        if (valueObj instanceof String) {
            if ("%?%".equals(likeStr)) {
                StringBuffer buf = new StringBuffer();
                buf.append("%");
                buf.append((String)valueObj);
                buf.append("%");
                return  buf.toString();
            }
            if ("?%".equals(likeStr)) {
                StringBuffer buf = new StringBuffer();
                buf.append((String)valueObj);
                buf.append("%");
                return  buf.toString();
            }
            if ("%?".equals(likeStr)) {
                StringBuffer buf = new StringBuffer();
                buf.append("%");
                buf.append((String)valueObj);
                return  buf.toString();
            }
        }
        return valueObj;
    }

    /**
     * 󔒂݂̂̕񂩂ǂ`FbNB<p>
     * ۂɂ́Ap󔒁ASp󔒁ACRALFA^uȊO
     * ĂȂ`FbNĂB
     * @param str
     * @return 󔒂݂̂Ȃtrue
     */
    public static boolean isSpaceOnly(String str) {
        
        for(int i=0; i<str.length(); i++) {
            char checkChar = str.charAt(i);
            if (checkChar == ' ') {
                continue;
            }
            if (checkChar == '@') {
                continue;
            }
            if (checkChar == '\n') {
                continue;
            }
            if (checkChar == '\r') {
                continue;
            }
            if (checkChar == '\t') {
                continue;
            }
            return false;
        }
        return true;
    }
}
