/*
 * Copyright 2004-2006 Robbie.JP
 */
package robbie.dao.x;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.jdom.Element;

import robbie.dao.QuerySupport;

import robbie.util.ClassFactory;


/**
 * XMLɒ`ꂽ񂩂AIɎsSQLƃoChϐMapList
 * 쐬Query̎NXB<p>
 * @see XQueryParseUtil
 */
public class XQuery extends QuerySupport {
    
    private static final long serialVersionUID = -3624781312816832754L;

    private static final Log LOG = LogFactory.getLog(XQuery.class);

    /** Query-ID */
    protected String queryId = null; 
    
    /** SQL̏Element */
    protected Element element = null;
    
    /** oChp[^Map */
    protected Map parameters = null;
    
    /**
     * ftHgRXgN^B<>
     */
    public XQuery() {
        super();
    }
    
    /**
     * SQL`ElementIuWFNgZbgB<p>
     * @param element SQL`ElementIuWFNg
     */
    public void setElement(Element element) {
        this.element = element;
    }

    /**
     * oChϐ̓MapZbgB<p>
     * @param parameters
     */
    public void setParameters(Map parameters) {
        this.parameters = parameters;
    }
    
    /**
     * sSQLƁAp[^List쐬B<p>
     * ͓̏Ă܂B
     */
    public void configure() {
        
        if (element == null) {
            throw new IllegalArgumentException("queryvfNULLł");
        }
        
        long startdate = 0;
        
        // debug
        if (LOG.isDebugEnabled()) {
            startdate = (new Date()).getTime();
            LOG.debug("Query̍\zJn܂.");
        }
        
        // oChϐi[Listnew
        parametersList = new ArrayList();
        
        // SQL쐬ăoϐփZbg
        String className = this.element.getAttributeValue("result");
        try {
            if (className != null && className.length() > 0) {
                resultClass = ClassFactory.getClass(className);
            }
        } catch(Exception ex) {
            throw new XDaoException("ϊBeanClass̐Ɏs܂B" +
                    "ŏ𒆒f܂BClass name=[" + className + "]", ex);
        }
        this.queryId = this.element.getAttributeValue("id");
        StringBuffer sqlStrBuf = null;
        try {
            sqlStrBuf = XQueryParseUtil.handleQueryElement(this.element, this.parameters, this.parametersList);
        } catch(XDaoException ex) {
            throw new XDaoException("Query̍\zŗOLb`܂BqueryId=[" + this.queryId + "]", ex);
        }
        if (sqlStrBuf != null) {
            this.sqlString = sqlStrBuf.toString();
        } else {
            throw new XDaoException("SQL񂪐ł܂łB" +
                    "ŏ𒆒f܂B Query =[" + this + "]");
        }
        
        // debug
        if (LOG.isDebugEnabled()) {
            long configuretime = (new Date()).getTime() - startdate;
            LOG.debug("Query̍\zI܂. vԂ " + configuretime +"(ms)ł.");
            LOG.debug(this);
        }
    }
    
    /**
     * toString()̃I[oChB<p>
     * @return ̃CX^X̕\L
     */
    public String toString() {
        String ls = System.getProperty("line.separator");
        return ls + 
        "Query-ID=[" + queryId + "]" + super.toString();
    }
}
