/*
 * Copyright 2004-2006 Robbie.JP
 */
package robbie.dao.x;

import java.util.List;

import java.sql.Connection;
import java.sql.SQLException;

import robbie.dao.BaseDao;
import robbie.dao.Query;
import robbie.dao.resource.DbResource;

/**
 * XDAONXB<p>
 * <pre>
 * ̃NX́AXMLt@Cɒ`ꂽASQLƃf[^x[X\[XgpāA
 * f[^x[XANZXsȂDAONXłBXML`𗘗pꍇɂ́A
 * ̃NXpNXƖvɎĂB
 * ܂ÃNXɂ̓ftHgŁAPgUNV̌ƍXV݂̂Ă܂B
 * gsȂꍇɂ́ÃNXpNX쐬AXML&lt;class-name&gt;
 * NXƗp郊\[Xݒ肵ĂB
 * </pre>
 * @see robbie.dao.BaseDao
 * @see robbie.dao.x.XQueryFactory
 * @see robbie.dao.resource.DbResource
 */
public class XDao extends BaseDao {

    private static final long serialVersionUID = 5877166542598269789L;
    
    /**
     * update\bhsSQLExceptionCatchۂɕԂXVB<p>
     * ۂɂ-1Ԃ܂B
     */
    public static final int CATCH_SQL_EXCEPTION_COUNT = -1;

    /**
     * XQueryFactoryNX̃CX^XB<p>
     * <pre>
     * ̕ϐ𗘗pāAsSQLCX^X擾܂B
     * TuNXł͈ȉ̂悤ɂāASQLCX^X擾
     * gsȂĂB
     * 
     * Query query = queryFactory.createSQLInstance(id, params);
     * 
     * </pre>
     * @see robbie.dao.Query
     * @see XQueryFactory#createQueryInstance(String, Object)
     */
    protected XQueryFactory queryFactory = null;
    
    /**
     * XDbResourceNX̃CX^XB<p>
     * <pre>
     * ̕ϐ𗘗pāAf[^x[XւConnection擾܂B
     * TuNXł͈ȉ̂悤ɂāAConnectionCX^X擾
     * gsȂĂB
     * 
     * java.sql.Connection conn = resource.getConnection();
     * 
     * </pre>
     * @see DbResource#getConnection()
     */
    protected DbResource resource = null;
    
    /**
     * O̍XVŔSQLExceptionB<p>
     */
    protected SQLException exception = null;
    
    /**
     * XQueryFactoryCX^XZbg܂B<p>
     * @param queryFactory XSQLFactoryCX^X
     */
    public void setQueryFactory(XQueryFactory queryFactory) {
        this.queryFactory = queryFactory;
    }

    /**
     * XDbResourceCX^XZbg܂B<p>
     * @param resource XmlDBResourceCX^X
     */
    public void setResource(DbResource resource) {
        this.resource = resource;
    }
    
    /**
     * O̍XVŎ擾SQLExceptionԂ܂B<p>
     * @return OɎ擾SQLException
     */
    public SQLException getSQLException() {
        return exception;
    }
    
    /**
     * configure()\bh̃I[oChB<p>
     * XDaoł͉Ă܂B
     * ̃\bh͏ƂXDaoCX^X쐬ɌĂяoĂ܂B
     * XDaõTuNXŏKvȏꍇ΁AI[oChĎgpĂB
     */
    public void configure() {
        // Ȃ
    }
    
    /**
     * ₢킹sAʂMapListŕԂ܂B<p>
     * <pre>
     * p[^Mapł͂ȂDynaBean܂JavaBeans̃vpeBgp܂B
     * AMap̃CX^XłꍇɂMap̗vfp[^Ƃ܂B
     * ̃\bh͂P̃gUNVs悤ɎĂ܂A
     * DataSource\[XgpāAJTÃgUNVRei
     * sĂꍇɂ́AReĩgUNVD悳܂B
     * ܂Ã\bh̒ŃRlNV擾AsListԂA
     * RlNVclose܂B
     * (JDBC\[X̏ꍇ̓R~bĝ݂close܂B܂AJTȀꍇɂ͎
     * ܂B)
     * </pre>
     * @param id queryid
     * @param params oChp[^MapAJavaBeansADynaBean
     * @return ʂMapList
     * @since 1.3.0
     */
    public List query(String id, Object params) {
        
        if (id == null) {
            throw new IllegalArgumentException("p[^idNULLł.");
        }
        
        Connection conn = null;
        try{
            conn = resource.getConnection();
            Query query = queryFactory.createQueryInstance(id, params);
            return executeQuery(conn, query);
        } catch(Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new XDaoException("catch exception.", ex);
        } finally {
            try {
                closeConnection(conn);
            } catch(Exception ex) {
                //throw new XDaoException("", ex);
            }
        }
    }
    
    /**
     * ₢킹sAʂObject[][]ŕԂ܂B<p>
     * <pre>
     * p[^Mapł͂ȂDynaBean܂JavaBeans̃vpeBgp܂B
     * AMap̃CX^XłꍇɂMap̗vfp[^Ƃ܂B
     * Object[0][*]̓J̃wb_ɂȂ܂B
     * f[^gpꍇɂ́AObject[1][*]gpĂ
     * </pre>
     * @param id queryid
     * @param params oChp[^MapAJavaBeansADynaBean
     * @return ʂ2z
     * @since 1.3.0
     */
    public Object[][] queryForArray(String id, Object params) {
        
        if (id == null) {
            throw new IllegalArgumentException("p[^idNULLł.");
        }
        
        Connection conn = null;
        try{
            conn = resource.getConnection();
            Query query = queryFactory.createQueryInstance(id, params);
            return executeQueryForArray(conn, query);
        } catch(Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new XDaoException("catch exception.", ex);
        } finally {
            try {
                closeConnection(conn);
            } catch(Exception ex) {
                //throw new XDaoException("", ex);
            }
        }
    }
    
    /**
     * ₢킹sAʂJavaBeansListŕԂ܂B<p>
     * <pre>
     * p[^Mapł͂ȂDynaBean܂JavaBeans̃vpeBgp܂B
     * AMap̃CX^XłꍇɂMap̗vfp[^Ƃ܂B
     * </pre>
     * @param id queryid
     * @param params oChp[^MapAJavaBeansADynaBean
     * @return JavaBeansList
     * @since 1.3.0
     */
    public List queryForBeans(String id, Object params) {
        
        if (id == null) {
            throw new IllegalArgumentException("p[^idNULLł. id" + id);
        }
        
        Connection conn = null;
        try{
            conn = resource.getConnection();
            Query query = queryFactory.createQueryInstance(id, params);
            return executeQueryForBeans(conn, query);
        } catch(Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new XDaoException("catch exception.", ex);
        } finally {
            try {
                closeConnection(conn);
            } catch(Exception ex) {
                //throw new XDaoException("", ex);
            }
        }
    }
    
    /**
     * ₢킹sAʂDynaBeanListŕԂ܂B<p>
     * <pre>
     * p[^Mapł͂ȂDynaBean܂JavaBeans̃vpeBgp܂B
     * AMap̃CX^XłꍇɂMap̗vfp[^Ƃ܂B
     * </pre>
     * @param id queryid
     * @param params oChp[^MapAJavaBeansADynaBean
     * @return DynaBeanList
     * @since 1.3.0
     */
    public List queryForDynaBean(String id, Object params) {
        
        if (id == null) {
            throw new IllegalArgumentException("p[^idNULLł. id" + id);
        }
        
        Connection conn = null;
        try{
            conn = resource.getConnection();
            Query query = queryFactory.createQueryInstance(id, params);
            return executeQueryForDynaBean(conn, query);
        } catch(Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new XDaoException("catch exception.", ex);
        } finally {
            try {
                closeConnection(conn);
            } catch(Exception ex) {
                //throw new XDaoException("", ex);
            }
        }
    }
    
    /**
     * XVs܂B<p>
     * <pre>
     * ̃\bhSQLExceptionꍇɂ́A-1Ԃ܂B
     * -1Ԃꂽꍇɂ͂SQLExceptionoϐƂĕێ܂̂ŁA
     * KvȏꍇɂgetSQLException()炻SQLException擾邱Ƃ\łB
     * ̃\bh͂P̃gUNVs悤ɎĂ܂A
     * DataSource\[XgpāAJTÃgUNVRei
     * sĂꍇɂ́AReĩgUNVD悳܂B
     * </pre>
     * @param id queryid
     * @param params oChp[^MapAJavaBeansADynaBean
     * @return XVASQLExceptionꍇɂ-1
     */
    public int update(String id, Object params) {
        
        if (id == null) {
            throw new IllegalArgumentException("p[^idNULLł.");
        }
        
        Connection conn = null;
        try{
            conn = resource.getConnection();
            Query query = queryFactory.createQueryInstance(id, params);
            return executeUpdate(conn, query);
        } catch(SQLException ex) {
            this.exception = ex;
            return CATCH_SQL_EXCEPTION_COUNT;
        } catch(Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new XDaoException("catch exception.", ex);
        } finally {
            try {
                closeConnection(conn);
            } catch(Exception ex) {
                //throw new XDaoException("", ex);
            }
        }
    }
    
    /**
     * f[^x[Xڑ\[XJ܂B<p>
     * f[^x[XڑSĊAK̃\bhĂłB
     */
    public void release() {
        resource.release();
    }
}
