/*
 * Copyright 2004-2006 Robbie.JP
 */
package robbie.dao.s;

import java.util.List;

import java.sql.Connection;
import java.sql.SQLException;

import robbie.dao.BaseDao;
import robbie.dao.DaoSysException;
import robbie.dao.Query;

import robbie.dao.resource.DbResource;


/**
 * BaseDAOpăf[^x[XɊȈՓIɐڑDAONXB<p>
 */
public class SDao extends BaseDao {

    private static final long serialVersionUID = -1223162757287442412L;
    
    private DbResource resource = null;
    
    /**
     * f[^x[XڑvpeBZbgB<p>
     * @param resource f[^x[Xڑ\[X 
     * @since 1.2.0
     */
    public void setDbResource(DbResource resource) {
        this.resource = resource;
    }
    
    /**
     * f[^x[XāǍʂMapLisť`ŕԂB<p>
     * @param query QueryCX^X
     * @return 1R[h1MapƂčXVʂԂB
     * @throws SQLException
     */
    public List query(Query query) throws SQLException {
        
        Connection conn = null;
        try{
            conn = resource.getConnection();
            return super.executeQuery(conn, query);
        } catch(Exception ex) {
            if (ex instanceof SQLException) {
                throw (SQLException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw(RuntimeException)ex;
            }
            throw new DaoSysException(ex);
        } finally {
            closeConnection(conn);
        }
    }
    
    /**
     * f[^x[XāǍʂ2ž`ŕԂB<p>
     * @param query QueryCX^X
     * @return ʂłObject2z
     * @throws SQLException
     */
    public Object[][] queryForArray(Query query) throws SQLException {
        
        Connection conn = null;
        try{
            conn = resource.getConnection();
            return super.executeQueryForArray(conn, query);
        } catch(Exception ex) {
            if (ex instanceof SQLException) {
                throw (SQLException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw(RuntimeException)ex;
            }
            throw new DaoSysException(ex);
        } finally {
            closeConnection(conn);
        }
    }
    
    /**
     * f[^x[XāǍʂJavaBeansListŕԂB<p>
     * @since 1.2.0
     * @param query QueryCX^X
     * @return ʂłJavaBeansList
     * @throws SQLException
     */
    public List queryForBeans(Query query) throws SQLException {
        
        Connection conn = null;
        try{
            conn = resource.getConnection();
            return super.executeQueryForBeans(conn, query);
        } catch(Exception ex) {
            if (ex instanceof SQLException) {
                throw (SQLException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw(RuntimeException)ex;
            }
            throw new DaoSysException(ex);
        } finally {
            closeConnection(conn);
        }
    }
    
    /**
     * f[^x[XāǍʂDynaBeanListŕԂB<p>
     * @since 1.3.0
     * @param query QueryCX^X
     * @return ʂłDynaBeansList
     * @throws SQLException
     */
    public List queryForDynaBeans(Query query) throws SQLException {
        
        Connection conn = null;
        try{
            conn = resource.getConnection();
            return super.executeQueryForDynaBean(conn, query);
        } catch(Exception ex) {
            if (ex instanceof SQLException) {
                throw (SQLException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw(RuntimeException)ex;
            }
            throw new DaoSysException(ex);
        } finally {
            closeConnection(conn);
        }
    }
    
    /**
     * f[^x[XXVA̍XVԂB<p>
     * @param query QueryCX^X
     * @return XV
     * @throws SQLException XVɎsꍇthrow܂B
     */
    public int update(Query query) throws SQLException {
        
        Connection conn = null;
        try{
            conn = resource.getConnection();
            return super.executeUpdate(conn, query);
        } catch(Exception ex) {
            if (ex instanceof SQLException) {
                throw (SQLException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw(RuntimeException)ex;
            }
            throw new DaoSysException(ex);
        } finally {
            closeConnection(conn);
        }
    }
    
    /**
     * f[^x[Xڑ\[XJ܂B<p>
     * f[^x[XڑSĊAK̃\bhĂłB
     */
    public void release() {
        resource.release();
    }
}
