/*
 * Copyright 2004-2006 Robbie.JP
 */
package robbie.dao;

import java.util.List;
import java.util.Map;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.IntrospectionException;

import java.io.IOException;
import java.io.Reader;

import java.lang.reflect.InvocationTargetException;

import java.math.BigDecimal;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.LazyDynaBean;
import org.apache.commons.beanutils.MutableDynaClass;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import robbie.util.CollectionsUtil;
import robbie.util.InstanceFactory;

/**
 * f[^x[X̐ڑpNX֘Ã[eBeBNXB<p>
 */
public class DaoUtil {
    
    private static final Log LOG = LogFactory.getLog(DaoUtil.class);

    private DaoUtil(){}
    
    /**
     * ResultSet()MapList쐬܂B<p>
     * @param rs ĂȂResultSet
     * @return 1R[hPMapɓꂽList
     * @throws SQLException
     */
    public static List resultSetToMapList(ResultSet rs) throws SQLException {
        
        List list = CollectionsUtil.createList();
        
        if (rs != null) {
            // Jz쐬
            ResultSetMetaData rsMetaData = rs.getMetaData();
            int columnCount = rsMetaData.getColumnCount();
            String[] columnNames = new String[columnCount];
            for(int i=0; i<columnCount; i++) {
                int name_i = i + 1;
                columnNames[i] = rsMetaData.getColumnName(name_i);
            }
            // ResultSet𗘗pĂ̌ʃXg쐬
            while(rs.next()) {
                Map columnMap = CollectionsUtil.createMap();
                for(int i=0; i<columnNames.length; i++) {
                    int object_i = i + 1;
                    columnMap.put(columnNames[i], rs.getObject(object_i));
                }
                list.add(columnMap);
            }
        }
        
        return list;
    }
    
    /**
     * ResultSet()Object[][]쐬܂B<p>
     * 擪s̓wb_łB
     * @param rs ĂȂResultSet
     * @return 擪swb_ƂȂ2zB
     * @throws SQLException
     */
    public static Object[][] resultSetToArray(ResultSet rs) throws SQLException {
        
        List list = CollectionsUtil.createList();
        
        if (rs != null) {
            // Jz쐬
            ResultSetMetaData rsMetaData = rs.getMetaData();
            int columnCount = rsMetaData.getColumnCount();
            Object[] columnNames = new Object[columnCount];
            for(int i=0; i<columnCount; i++) {
                int name_i = i + 1;
                columnNames[i] = rsMetaData.getColumnName(name_i);
            }
            // Header
            list.add(columnNames);
            
            // ResultSet𗘗pĂ̌ʃXg쐬
            while(rs.next()) {
                Object[] columnValue = new Object[columnCount];
                for(int i=0; i<columnCount; i++) {
                    int object_i = i + 1;
                    columnValue[i] = rs.getObject(object_i);
                }
                // record
                list.add(columnValue);
            }
        }
        
        // Object[] -> Object[][] ϊ
        Object[] before = list.toArray();
        Object[][] after = new Object[before.length][];
        for(int i=0; i<before.length; i++) {
            after[i] = (Object[])before[i];
        }
        return after;
    }
    
    /**
     * ResultSet̒lJavaBeansListɕϊB<p>
     * @param beanClass JavaBeasnsNX
     * @param rs ʂێResultSet
     * @return JavaBeansList
     * @throws Exception
     */
    public static List resultSetToBeansList(Class beanClass, ResultSet rs) 
        throws Exception {
        
        List beanList = CollectionsUtil.createList();
        if (rs != null) {
            // JMap쐬
            ResultSetMetaData rsMetaData = rs.getMetaData();
            int columnCount = rsMetaData.getColumnCount();
            String[] columnNames = new String[columnCount];
            for(int i=0; i<columnNames.length; i++) {
                columnNames[i] = rsMetaData.getColumnName(i+1);
            }
            
            // PropertyDescriptorMap쐬
            BeanInfo info = Introspector.getBeanInfo(beanClass);
            PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
            if (descriptors == null) {
                // NULLԂꍇɂ͗vf̂ȂListԂ
                return beanList;
            }
            Map descriptorMap = CollectionsUtil.createMap();
            for(int i=0; i<descriptors.length; i++) {
                descriptorMap.put(descriptors[i].getName().toLowerCase(), descriptors[i]);
            }
            
            // ResultSet𗘗pĂ̌ʃXg쐬
            while(rs.next()) {
                Object bean = InstanceFactory.createInstance(beanClass);
                
                // Beans̃vpeB̐f[^Zbg
                for(int i=0; i<columnNames.length; i++) {
                    // JƈvvpeB݂Ȃ΃f[^̓ZbgȂ
                    String columnName = columnNameToPropertyName(columnNames[i]).toLowerCase();
                    if (descriptorMap.containsKey(columnName)) {
                        // \bh̓IȎs
                        PropertyDescriptor descriptor = 
                            (PropertyDescriptor)descriptorMap.get(columnName);
                        
                        // Object̔z
                        //Object arg = convertObjectIfNeeded(
                        //        descriptor.getPropertyType(),
                        //        descriptor.getName(), 
                        //        columnNames[i],
                        //        rs.getObject(i+1));
                        
                        // w肵^Ńf[^擾
                        Object arg = getObjectFromResultSet(descriptor.getPropertyType(), rs, i+1);
                        
                        Object[] args = {arg};
                       
                        descriptor.getWriteMethod().invoke(bean, args);
                    }
                }
                beanList.add(bean);
            }
        }
        return beanList;
    }
    
    /**
     * ResultSetDynaBeanList֕ϊB<p>
     * @param rs ʂێResultSet
     * @return LazyDynaBeanList
     * @throws Exception
     * @since 1.3.0
     */
    public static List resultSetToDynaBeanList(ResultSet rs) 
            throws Exception {
        
        List list = CollectionsUtil.createList();
        
        if (rs != null) {
            // Jz쐬
            ResultSetMetaData rsMetaData = rs.getMetaData();
            int columnCount = rsMetaData.getColumnCount();
            String[] columnNames = new String[columnCount];
            for(int i=0; i<columnCount; i++) {
                int name_i = i + 1;
                columnNames[i] = rsMetaData.getColumnName(name_i);
            }
            // ResultSet𗘗pĂ̌ʃXg쐬
            while(rs.next()) {
                DynaBean bean = new LazyDynaBean();
                MutableDynaClass beanClass = (MutableDynaClass)bean.getDynaClass();
                for(int i=0; i<columnNames.length; i++) {
                    int object_i = i + 1;
                    // property-name
                    String propertyName = columnNameToPropertyName(columnNames[i]);
                    // setting-value
                    Object value = rs.getObject(object_i);
                    
                    // set-property-class-info
                    beanClass.add(propertyName, value.getClass());
                    // set-property-value
                    bean.set(propertyName, value);
                }
                list.add(bean);
            }
        }
        
        return list;
    }
    
    /**
     * DynaBean܂JavaBeans̃vpeBMapɕϊB<p>
     * @param beans JavaBeansCX^X
     * @return vpeBKEYɂMap
     * @throws IntrospectionException
     * @throws IllegalAccessException
     * @throws InvocationTargetException
     */
    public static Map beansToMap(Object beans) 
            throws IntrospectionException, IllegalAccessException, InvocationTargetException {

        if (beans instanceof Map) {
            Map map = CollectionsUtil.createMap();
            map.putAll((Map)beans);
            return map;
        } else if (beans instanceof DynaBean) {
            return dynaBeanToMap((DynaBean)beans);
        } else {
            return javaBeansToMap(beans);
        }

    }
    
    /**
     * DynaBeanMap֕ϊB<p>
     * @param bean@DynaBeanCX^X
     * @return@ϊ̃vpeBKEYɂMap
     */
    protected static Map dynaBeanToMap(DynaBean bean) {
        
        Map map = CollectionsUtil.createMap();
        
        if (bean == null) {
            return map;
        }
        
        DynaProperty[] props = bean.getDynaClass().getDynaProperties();
        for (int i=0; i<props.length; i++) {
            DynaProperty prop = props[i];
            String propertyName = prop.getName();
            map.put(propertyName, bean.get(propertyName));
        }
        
        return map; 
    }
    
    /**
     * ObjectJavaBeansƂ݂ȂăCX^XϊB<p>
     * @param beans MapADynaBeanȊOObject
     * @return@ϊ̃vpeBKEYɂMap
     * @throws IntrospectionException
     * @throws IllegalAccessException
     * @throws InvocationTargetException
     */
    protected static Map javaBeansToMap(Object beans)
            throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        
        Map map = CollectionsUtil.createMap();
        
        if (beans == null) {
            return map;
        }
        
        Class beansClass = beans.getClass();
        BeanInfo info = Introspector.getBeanInfo(beansClass);
        PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
        if (descriptors == null) {
            // NULLԂꍇɂNULLԂ
            return null;
        }
        for(int i=0; i<descriptors.length; i++) {
            PropertyDescriptor descriptor = descriptors[i];
            Object[] args = {};
            map.put(descriptors[i].getName(), descriptor.getReadMethod().invoke(beans, args));
        }
        return map;
    }
    
    
    /**
     * J'_'݂ꍇA폜B
     * @param columnName J
     * @return '_'폜J
     * @since 1.1.0
     */
    protected static String columnNameToPropertyName(String columnName) {
        return columnName.replaceAll("[_]", "");
    }
    
    /**
     * ResultSeťݍs̎w肵Aw肵^Ŏ擾B<p>
     * @param type@擾f[^^
     * @param rs@ResultSetIuWFNg
     * @param i@̔ԍ
     * @return@擾Object
     * @throws SQLException
     * @throws IOException
     * @since 1.3.0
     */
    protected static Object getObjectFromResultSet(Class type, ResultSet rs, int i) 
            throws SQLException, IOException {
        
        if (String.class.equals(type)) {
            return rs.getString(i);
        } else if (Integer.TYPE.equals(type)) {
            return new Integer(rs.getInt(i));
        } else if (Long.TYPE.equals(type)) {
            return new Long(rs.getLong(i));
        } else if (Short.TYPE.equals(type)) {
            return new Short(rs.getShort(i));
        } else if (Float.TYPE.equals(type)) {
            return new Float(rs.getFloat(i));
        } else if (Double.TYPE.equals(type)) {
            return new Double(rs.getDouble(i));
        } else if (Boolean.TYPE.equals(type)) {
            return new Boolean(rs.getBoolean(i));
        } else if (Byte.TYPE.equals(type)) {
            return new Byte(rs.getByte(i));
        } else if (Character.TYPE.equals(type)) {
            Reader reader = null;
            try {
                reader = rs.getCharacterStream(i);
                int ch = reader.read();
                return new Character((char)ch);
            } finally {
                if (reader != null) {
                    reader.close();
                }
            }
        } else if (java.sql.Array.class.equals(type)) {
            return rs.getArray(i);
        } else if (java.sql.Blob.class.equals(type)) {
            return rs.getBlob(i);
        } else if (java.sql.Clob.class.equals(type)) {
            return rs.getClob(i);
        } else if (java.sql.Date.class.equals(type)) {
            return rs.getDate(i);
        } else if (java.sql.Ref.class.equals(type)) {
            return rs.getRef(i);
        } else if (java.sql.Time.class.equals(type)) {
            return rs.getTime(i);
        } else if (java.sql.Timestamp.class.equals(type)) {
            return rs.getTimestamp(i);
        } else if (BigDecimal.class.equals(type)) {
            return rs.getBigDecimal(i);
        } else if (java.net.URL.class.equals(type)) {
            return rs.getURL(i);
        } else {
            return rs.getObject(i);
        }
    }
    
    /**
     * Kvł΁Alf[^̌^ϊsB<p>
     * @param objClass ϊPropertyClass
     * @param propName ϊPropety
     * @param columnName f[^x[X̃J(SQL̃GCAX)
     * @param obj f[^x[Xϊf[^
     * @return ϊObject
     * @deprecated
     */
    protected static Object convertObjectIfNeeded(
            Class objClass,
            String propName, 
            String columnName, 
            Object obj) {
        
        // OƂāAł̓v~eBu^ւ̃f[^Zbg̃A}b`
        // ߂̏s܂B
        // 
        // i)   Zbg^Ashort, int, long, float, doublełAZbgf[^ 
        //      NumberC^tF[Xꍇɂ́AK؂Ȍ`̃bpNX
        //      Object֕ϊB
        // 
        // ii)  Zbg^AShort, Integer, Long, Float, DoublełAZbgf[^ 
        //      NumberC^tF[X邪AZbg^ƈvȂꍇɂ́A
        //      K؂Ȍ`̃bpNXObject֕ϊB
        // 
        // iii) Zbg^Abyte, char, booleanłAZbgf[^ 
        //      ̃bpNXłȂA܂NULLłꍇɂ́Av~eBu^
        //      l֕ϊB
        // 
        // ݌vƁȀ͏dȃVXeIȃoON\܂B
        // ]āAJavaBeans̐݌vA[LeNǵAf[^͈̔͂ƈvK؂
        // v~eBu^̃vpeBBean݌vȂĂ͂Ȃ܂B
        
        if (LOG.isDebugEnabled()) {
            String className = null;
            if (obj != null) {
                className = obj.getClass().getName();
            } else {
                className = "null";
            }
            LOG.debug(
                    "^ϊ " +
                    "J:" + columnName + "(^=" + className + ":l=" + obj + ") => " +
                    "vpeB:" + propName + "(^=" + objClass.getName() + ")");
        }
        
        if (isPrimitiveType(objClass)) {
            // v~eBu^̏ꍇ
            if (Integer.TYPE.equals(objClass)) {
                if (obj instanceof Integer) {
                    return obj;
                } else if (obj instanceof Number) {
                    return new Integer(((Number)obj).intValue());
                } else if (obj == null) {
                    return new Integer(0);
                }
                throw new DaoSysException("ϊǑ^Integer܂Numberł͂܂. obj=" + obj);
            }
            if (Long.TYPE.equals(objClass)) {
                if (obj instanceof Long) {
                    return obj;
                } else if (obj instanceof Number) {
                    return new Long(((Number)obj).longValue());
                } else if (obj == null) {
                    return new Long(0);
                }
                throw new DaoSysException("ϊǑ^Long܂Numberł͂܂. obj=" + obj);
            }
            if (Short.TYPE.equals(objClass)) {
                if (obj instanceof Short) {
                    return obj;
                } else if (obj instanceof Number) {
                    return new Short(((Number)obj).shortValue());
                } else if (obj == null) {
                    return new Short((short)0 );
                }
                throw new DaoSysException("ϊǑ^Short܂Numberł͂܂. obj=" + obj);
            }
            if (Float.TYPE.equals(objClass)) {
                if (obj instanceof Float) {
                    return obj;
                } else if (obj instanceof Number) {
                    return new Float(((Number)obj).floatValue());
                } else if (obj == null) {
                    return new Float(0.0f);
                }
                throw new DaoSysException("ϊǑ^Float܂Numberł͂܂. obj=" + obj);
            }
            if (Double.TYPE.equals(objClass)) {
                if (obj instanceof Double) {
                    return obj;
                } else if (obj instanceof Number) {
                    return new Double(((Number)obj).doubleValue());
                } else if (obj == null) {
                    return new Double(0.0d);
                }
                throw new DaoSysException("ϊǑ^Double܂Numberł͂܂. obj=" + obj);
            }
            if (Boolean.TYPE.equals(objClass)) {
                if (obj instanceof Boolean) {
                    return obj;
                } else if (obj == null) {
                    return new Boolean(false);
                }
                throw new DaoSysException("ϊǑ^Booleanł͂܂. obj=" + obj);
            }
            if (Byte.TYPE.equals(objClass)) {
                if (obj instanceof Byte) {
                    return obj;
                } else if (obj == null) {
                    return new Byte((byte)0);
                }
                throw new DaoSysException("ϊǑ^Byteł͂܂. obj=" + obj);
            }
            if (Character.TYPE.equals(objClass)) {
                if (obj instanceof Character) {
                    return obj;
                } else if (obj == null) {
                    return new Character('\u0000');
                }
                throw new DaoSysException("ϊǑ^Characterł͂܂. obj=" + obj);
            }
        } else if (obj instanceof Number) {
            // v~eBu^̃bpNX̏ꍇ
            if (Integer.class.equals(objClass)) {
                if (obj instanceof Integer) {
                    return obj;
                }
                return new Integer(((Number)obj).intValue());
            }
            if (Long.TYPE.equals(objClass)) {
                if (obj instanceof Long) {
                    return obj;
                }
                return new Long(((Number)obj).longValue());
            }
            if (Short.TYPE.equals(objClass)) {
                if (obj instanceof Short) {
                    return obj;
                }
                return new Short(((Number)obj).shortValue());
            }
            if (Float.TYPE.equals(objClass)) {
                if (obj instanceof Float) {
                    return obj;
                }
                return new Float(((Number)obj).floatValue());
            }
            if (Double.TYPE.equals(objClass)) {
                if (obj instanceof Double) {
                    return obj;
                }
                return new Double(((Number)obj).doubleValue());
            }
        }
        return obj;
    }
    
    private static boolean isPrimitiveType(Class objClass) {
        
        if (Integer.TYPE.equals(objClass)
                || Long.TYPE.equals(objClass)
                || Float.TYPE.equals(objClass)
                || Double.TYPE.equals(objClass)
                || Boolean.TYPE.equals(objClass)
                || Short.TYPE.equals(objClass)
                || Byte.TYPE.equals(objClass)
                || Character.TYPE.equals(objClass)
                ) {
            return true;
        }
        return false;
    }
}
