/*
 * Copyright 2004-2006 Robbie.JP
 */
package robbie.dao;

import java.util.Map;
import java.util.List;
import java.util.Iterator;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.PreparedStatement;
import java.sql.SQLException;


/**
 * DAÕx[XNXB<p>
 * ̃NXɂpublic\bh͎Ă܂B
 * ̃NX͕KpĂApKv܂B<br>
 * g̕@́ASDaoсAXDaoAGeneralizedXDao̎mFĉB
 * @see robbie.dao.x.XDao
 * @see robbie.dao.x.GeneralizedXDao
 * @see robbie.dao.s.SDao
 */
public class BaseDao implements java.io.Serializable {
    
    private static final long serialVersionUID = -3734013538684469448L;
    
    /**
     * RlNVN[YB<p>
     * @param conn ConnectionCX^X
     * @throws SQLException
     */
    protected void closeConnection(Connection conn) throws SQLException {
        if (conn != null) {
            conn.close();
        }
    }
    
    /**
     * RlNVJĂ邩ǂ`FbN܂B<p>
     * JTAɂăgUNVǗĂꍇɂ́A
     * ̃\bhgpƖ肪ꍇ܂B
     * @param conn ConnectionCX^X
     * @return ConnectionI[vĂtrue
     * @throws SQLException
     */
    protected boolean isClosed(Connection conn) throws SQLException {
        if (conn != null) {
            return conn.isClosed();
        } 
        return false;
    }
    
    /**
     * AutoCommit[hZbg܂B<p>
     * JDBC̎dlł́AConnection擾ۂɂ́AftHgAutoCommit[h
     * trueɂȂ܂BāAGȃgUNVsȂA
     * [obNAR~bg𑽗pꍇɂ́A炩߃I[gR~bg
     * falseɐݒ肵ĂKv܂B<p>
     * ܂AJTAɂăgUNVǗĂꍇɂ́A
     * ̃\bhgpƖ肪ꍇ܂B
     * @param conn ConnectionCX^X
     * @param isAutoCommit Lɂꍇɂtrue
     * @throws SQLException
     */
    protected void setAutoCommit(Connection conn, boolean isAutoCommit) throws SQLException {
        if (!isClosed(conn)) {
            conn.setAutoCommit(isAutoCommit);
        }
    }
    
    /**
     * R~bgB<p>
     * JTAɂăgUNVǗĂꍇɂ́A
     * ̃\bhgpƖ肪ꍇ܂B
     * @param conn ConnectionCX^X
     * @throws SQLException
     */
    protected void commit(Connection conn) throws SQLException {
        if (!isClosed(conn)) {
            conn.commit();
        }
    }

    /**
     * [obNB<p>
     * JTAɂăgUNVǗĂꍇɂ́A
     * ̃\bhgpƖ肪ꍇ܂B
     * @param conn ConnectionCX^X
     * @throws SQLException
     */
    protected void rollback(Connection conn) throws SQLException {
        if (!isClosed(conn)) {
            conn.rollback();
        }
    }
    
    /**
     * ₢킹sAʂMapListŕԂ܂B<p>
     * ResultSetStatementClose͍s܂ARlNVCloses܂B
     * 
     * <pre>
     * gpF
     * ̃\bhgpꍇɂ́ATuNXňȉ̂悤ɁA
     * RlNV̎擾close()ǗȂA
     * Kv܂B
     * 
     * Connection conn = null;
     * try {
     *     // 炩̎gpāAI[vꂽ
     *     // ConnecionIuWFNg擾܂B
     *     conn = resource.getConnection();
     *     
     *     // QuerỹIuWFNgnĖ⍇s
     *     List result = executeQuery(conn, query):
     *     
     *     ...炩̏ʂ̖⍇
     *     
     * } finally {
     * @@// closeConnection()ŕKConnectionBcloseConnection()
     * @@// ConnectionIuWFNgnullłΉȂB
     *     closeConnection(conn);
     * }
     * 
     * </pre>
     * @see #closeConnection(Connection)
     * @param conn ConnectionCX^X
     * @param query QueryIuWFNg
     * @return List MapList
     * @throws SQLException
     */
    protected List executeQuery(Connection conn, Query query) throws SQLException {
        
        if (conn == null) {
            throw new IllegalArgumentException("ConnectionNULLł.");
        }
        
        if (query == null) {
            throw new IllegalArgumentException("Queryp[^NULLł.");
        }
        
        PreparedStatement sts = null;
        ResultSet rs = null;
        try {
            sts = openStatement(conn, query.getSQLString());
            rs = openQuery(sts, query.getBindParametersMapList());
            return DaoUtil.resultSetToMapList(rs);
        } finally {
            closeQuery(sts, rs);
        }
    }
    
    /**
     * ₢킹sAʂObject[][]ŕԂ܂B<p>
     * Object[0][*]̓J̃wb_ɂȂ܂B
     * f[^gpꍇɂ́AObject[1][*]gpĂ
     * @see #executeQuery(Connection, Query)
     * @param conn ConnectionCX^X
     * @param query QueryIuWFNg
     * @return ʂ̂Qz
     * @throws SQLException
     */
    protected Object[][] executeQueryForArray(Connection conn, Query query) throws SQLException {
        
        if (conn == null) {
            throw new IllegalArgumentException("ConnectionNULLł.");
        }
        
        if (query == null) {
            throw new IllegalArgumentException("Queryp[^NULLł.");
        }
        
        PreparedStatement sts = null;
        ResultSet rs = null;
        try {
            sts = openStatement(conn, query.getSQLString());
            rs = openQuery(sts, query.getBindParametersMapList());
            return DaoUtil.resultSetToArray(rs);
        } finally {
            closeQuery(sts, rs);
        }
    }
    
    /**
     * ₢킹sAʂJavaBeansListŕԂ܂B<p>
     * @param conn ConnectionCX^X
     * @param query QueryIuWFNg
     * @return ʂJavaBeansList
     * @throws SQLException
     */
    protected List executeQueryForBeans(Connection conn, Query query) throws SQLException {
        
        if (conn == null) {
            throw new IllegalArgumentException("ConnectionNULLł.");
        }
        
        if (query == null) {
            throw new IllegalArgumentException("Queryp[^NULLł.");
        }
        
        if (query.getReslutClass() == null) {
            throw new IllegalArgumentException("JavaBeansϊ̃NXNULLł.");
        }
        
        PreparedStatement sts = null;
        ResultSet rs = null;
        try {
            sts = openStatement(conn, query.getSQLString());
            rs = openQuery(sts, query.getBindParametersMapList()); 
            return DaoUtil.resultSetToBeansList(query.getReslutClass(), rs);
        } catch(Exception ex){
            if (ex instanceof SQLException) {
                throw (SQLException)ex;
            }
            throw new DaoSysException(ex);
        } finally {
            closeQuery(sts, rs);
        }
    }
    
    /**
     * ₢킹sAʂJavaBeansListŕԂ܂B<p>
     * @param conn ConnectionCX^X
     * @param query QueryIuWFNg
     * @return ʂDynaBeanList
     * @throws SQLException
     */
    protected List executeQueryForDynaBean(Connection conn, Query query) throws SQLException {
        
        if (conn == null) {
            throw new IllegalArgumentException("ConnectionNULLł.");
        }
        
        if (query == null) {
            throw new IllegalArgumentException("Queryp[^NULLł.");
        }
        
        PreparedStatement sts = null;
        ResultSet rs = null;
        try {
            sts = openStatement(conn, query.getSQLString());
            rs = openQuery(sts, query.getBindParametersMapList()); 
            return DaoUtil.resultSetToDynaBeanList(rs);
        } catch(Exception ex){
            if (ex instanceof SQLException) {
                throw (SQLException)ex;
            }
            throw new DaoSysException(ex);
        } finally {
            closeQuery(sts, rs);
        }
    }
    
    /**
     * XVs܂B<p>
     * StatementClose͍s܂ARlNVClose͍s܂B
     * <pre>
     * gpF
     * ̃\bhgpꍇɂ́ATuNXňȉ̂悤ɁA
     * RlNV̎擾close()ǗȂA
     * Kv܂B
     * 
     * Connection conn = null;
     * try {
     *     // 炩̎gpāAI[vꂽ
     *     // ConnecionIuWFNg擾܂B
     *     conn = ...
     *     
     *     // SQL̃IuWFNgnčXVs
     *     int count = executeUpdate(conn, query):
     *     
     *     // ƂāAXVsȂĂtrueA
     *     // 1sXVĂȂfalseԂ
     *     if(count > 0) {
     *         return true;
     *     }
     *     return false;
     *     
     * } finally {
     *     // closeConnection()ŕKConnectionBcloseConnection()
     *     // ConnectionIuWFNgnullłΉȂB
     *     closeConnection(conn);
     * }
     * 
     * </pre>
     * ܂ÃNXStatementĂ܂߁ASQL͍ėpł܂B<p>
     * ob`̂悤SQLėp邽߂ɂ́ATuNXopenStatement()
     * bindParameters()ȂǂAPI𗘗pčĎKv܂B<p>
     * 
     * @see #closeConnection(Connection)
     * @param conn ConnectionCX^X
     * @param query QueryNX
     * @return XV
     * @throws SQLException
     */
    protected int executeUpdate(Connection conn, Query query) throws SQLException {
        
        if (conn == null) {
            throw new IllegalArgumentException("ConnectionNULLł.");
        }
        
        if (query == null) {
            throw new IllegalArgumentException("Queryp[^NULLł.");
        }
        
        int count = 0;
        PreparedStatement sts = null;
        try {
            String sqlStr = query.getSQLString();
            List params = query.getBindParametersMapList();
            sts = openStatement(conn, sqlStr);
            bindParameters(sts, params);
            count = sts.executeUpdate();
        } finally {
            closeStatement(sts);
        }
        return count;
    }
    
    /**
     * StatementCX^XԂ܂B<p>
     * p@openQuery()̎gpmFĂB
     * @see #openQuery(PreparedStatement sts, List params)
     * @param conn ConnectionCX^X
     * @param sql SQL
     * @return PreparedStatementIuWFNg
     * @throws SQLException
     */
    protected PreparedStatement openStatement(Connection conn, String sql) throws SQLException {
        
        if (conn == null) {
            throw new IllegalArgumentException("ConnectionNULLł.");
        }
        
        if (sql == null) {
            throw new IllegalArgumentException("SQLNULLł.");
        }
        
        return conn.prepareStatement(sql);
    }
    
    /**
     * sAResultSetԂ܂B<p>
     * executeQuerýAʂMapListŕԂ܂Ã\bhł́A
     * openꂽStatementɃoChϐZbgāAResultSet
     * Ԃ܂B<p>
     * <pre>
     * gpF
     * ̃\bhgpꍇɂ́ATuNXňȉ̂悤ɁA
     * PreparedStatementAResultSetAConnection̎擾close()A
     * SQLNXǗȂAKv܂B
     * 
     * Connection conn = null;
     * PreparedStatement statement = null;
     * ResultSet reslut = null;
     * try {
     *     // 炩̎gpāAI[vꂽ
     *     // Connecion擾܂B
     *     conn = .....
     *     
     *     // QuerỹIuWFNgSQLoChϐMapList
     *     // o܂B
     *     String sqlStr = query.getSQLString();
     *     List params = query.getBindParametersMapList();
     *     
     *     // StatementOPENASQLsResultSet擾܂B
     *     statement = openStatement(conn, sqlStr);
     *     result = openQuery(statement, params);
     *     
     *     // ResutlSetgpĉ̏sȂ܂B
     *     
     *     EEEEE
     *     
     * } finally {
     *     // KPreparedStatementAResultSetAConnection
     *     // ܂B
     *     try {
     *         closeQuery(statement, reslut);
     *     } finally {
     *         closeConnection(conn);
     *     }
     * }
     * 
     * </pre>
     * @see #openStatement(Connection, String sql)
     * @see #bindParameters(PreparedStatement sts, List params)
     * @see #closeQuery(PreparedStatement sts, ResultSet rs)
     * @see #closeConnection(Connection)
     * @param sts I[vStatement
     * @param params SQLbpIuWFNg
     * @return sResultSet
     * @throws SQLException
     */
    protected ResultSet openQuery(PreparedStatement sts, List params) 
            throws SQLException {
        
        if (sts == null) {
            throw new IllegalArgumentException("StatementNULLł.");
        }
        
        bindParameters(sts, params);
        return sts.executeQuery();
    }
    
    /**
     * PreparedStatemanetMapList̃p[^oChĂ܂B<p>
     * ̃\bhopenQueryďoĂ܂B
     * <pre>
     * openQuery̎́Aȉ̂悤ɂȂĂ܂B
     * 
     *      protected ResultSet openQuery(PreparedStatement sts, List params) 
     *              throws SQLException {
     *          
     *          bindParameters(sts, params);
     *          return sts.executeQuery();
     *      }
     * 
     * L̂悤openꂽXe[ggɐVɃp[^ZbgāA
     * SQLsĂ܂B
     * 
     * pF
     * openQuery()̎QlɁAsp[^̔zpӂ
     * ȉ̂悤ɏsȂ΁Aob`IɃf[^x[X
     * XV邱Ƃ\ɂȂ܂B
     * 
     *      for(int i=0; i&lt;params.length; i++) {
     *          bindParameters(sts, params[i]);
     *          sts.executeUpdate();
     *      }
     * 
     *      *) paramśAList̔zƂ
     * 
     * </pre>
     * @see #openQuery(PreparedStatement sts, List params)
     * @param sts openĂPrepaedStatement
     * @param params oChϐMapList
     * @throws SQLException
     */
    protected void bindParameters(PreparedStatement sts, List params) 
            throws SQLException {
        
        if (sts == null) {
            throw new IllegalArgumentException("StatementNULLł.");
        }
        
        if (params != null) {
            int i=1;
            for(Iterator it = params.iterator(); it.hasNext(); i++) {
                Map map = (Map)it.next();
                Object obj = map.get(DaoKeys.VALUE_KEY);
                Integer type = (Integer)map.get(DaoKeys.TYPE_KEY);
                if (obj != null) {
                    sts.setObject(i,obj);
                } else {
                    if(type == null) {
                        sts.setNull(i, java.sql.Types.VARCHAR);
                    } else {
                        sts.setNull(i, type.intValue());
                    }
                }
            }
        }
    }
    
    /**
     * ܂B<p>
     * ۂɂResultSetPreparedStatementclose()Ă܂B
     * p@openQuery()̎gpmFĂB
     * @see #openQuery(PreparedStatement sts, List params)
     * @param sts openĂPrepaedStatement
     * @param rs openĂResultSet
     * @throws SQLException
     */
    protected void closeQuery(PreparedStatement sts, ResultSet rs) 
            throws SQLException {
        closeResultSet(rs);
        closeStatement(sts);
    }
    
    /**
     * StatementCX^X܂B<p>
     * @param sts openĂPrepaedStatemen
     * @throws SQLException
     */
    protected void closeStatement(PreparedStatement sts) throws SQLException {
        if (sts != null) {
            sts.close();
        }
    }
    
    /**
     * ResultSetCX^X܂B<p>
     * @param rs openĂResultSet
     * @throws SQLException
     */
    protected void closeResultSet(ResultSet rs) throws SQLException {
        if (rs != null) {
            rs.close();
        }
    }
}
