/*
 * Decompiled with CFR 0.152.
 */
package robbie.dao.x;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Text;
import robbie.dao.DaoTypes;
import robbie.dao.x.XQueryParseFailureException;

public class XQueryParseUtil {
    private XQueryParseUtil() {
    }

    public static StringBuffer handleQueryElement(Element ele, Map params, List paramsMapList) {
        StringBuffer sqlStrBuff = new StringBuffer();
        List children = ele.getContent();
        Iterator it = children.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof String) {
                sqlStrBuff.append((String)obj);
                continue;
            }
            if (obj instanceof Text) {
                sqlStrBuff.append(((Text)obj).getText());
                continue;
            }
            StringBuffer tmpBuff = null;
            Element child = (Element)obj;
            if (child.getName().equals("var")) {
                tmpBuff = XQueryParseUtil.handleVarElement(child, params, paramsMapList);
            } else if (child.getName().equals("repeat")) {
                tmpBuff = XQueryParseUtil.handleRepeatElement(child, params, paramsMapList);
            } else if (child.getName().equals("between")) {
                tmpBuff = XQueryParseUtil.handleBetweenElement(child, params, paramsMapList);
            } else if (child.getName().equals("switch")) {
                tmpBuff = XQueryParseUtil.handleSwitchElement(child, params, paramsMapList);
            } else if (child.getName().equals("list")) {
                tmpBuff = XQueryParseUtil.handleListElement(child, params, paramsMapList);
            } else if (child.getName().equals("where")) {
                tmpBuff = XQueryParseUtil.handleWhereElement(child, params, paramsMapList);
            } else {
                throw new XQueryParseFailureException("\u8981\u7d20\u540d\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093. element=" + ele.getName());
            }
            if (tmpBuff == null) continue;
            sqlStrBuff.append(tmpBuff);
        }
        if (XQueryParseUtil.isSpaceOnly(sqlStrBuff.toString())) {
            return null;
        }
        return sqlStrBuff;
    }

    public static StringBuffer handleConstElement(Element ele, Map params, List paramsMapList) {
        String sqlStr;
        String reqStr = ele.getAttributeValue("req");
        if (reqStr != null) {
            Boolean isRequired = Boolean.valueOf(reqStr);
            String keyStr = ele.getAttributeValue("key");
            if (isRequired.booleanValue()) {
                if (keyStr == null || keyStr.length() == 0 || !params.containsKey(keyStr)) {
                    throw new XQueryParseFailureException("req\u8981\u7d20\u304c\u5b58\u5728\u3059\u308b\u306e\u306b\u30d1\u30e9\u30e1\u30fc\u30bfMap\u306b\u5024\u304c\u5b58\u5728\u3057\u307e\u305b\u3093. element=" + ele.getName() + " req=" + reqStr + " key=" + keyStr);
                }
            } else if (keyStr == null || keyStr.length() == 0 || !params.containsKey(keyStr)) {
                return null;
            }
        }
        if (XQueryParseUtil.isSpaceOnly(sqlStr = ele.getText())) {
            return null;
        }
        return new StringBuffer(sqlStr);
    }

    public static StringBuffer handleVarElement(Element ele, Map params, List paramsMapList) {
        String keyStr = ele.getAttributeValue("key");
        if (keyStr == null) {
            throw new XQueryParseFailureException("key\u5c5e\u6027\u304c\u5b58\u5728\u3057\u307e\u305b\u3093. element=" + ele.getName());
        }
        if (params == null || !params.containsKey(keyStr)) {
            if (ele.getAttributeValue("req") == null) {
                throw new XQueryParseFailureException("var\u8981\u7d20\u306breq\u5c5e\u6027\u304c\u5b58\u5728\u3057\u307e\u305b\u3093. element=" + ele.getName());
            }
            Boolean isRequired = Boolean.valueOf(ele.getAttributeValue("req"));
            if (isRequired.booleanValue()) {
                throw new XQueryParseFailureException(" var\u8981\u7d20\u306ereq\u5c5e\u6027\u304ctrue\u306a\u306e\u306b\u30d1\u30e9\u30e1\u30fc\u30bf\u304cMap\u306b\u5b58\u5728\u3057\u307e\u305b\u3093. key=" + keyStr);
            }
            return null;
        }
        String typeStr = ele.getAttributeValue("type");
        Object valueObj = params.get(keyStr);
        if (valueObj != null && valueObj.getClass().isArray()) {
            valueObj = ((Object[])valueObj)[0];
        }
        if (ele.getAttribute("like") != null) {
            valueObj = XQueryParseUtil.handleLikeAttribute(ele.getAttributeValue("like"), valueObj);
        }
        HashMap parameterMap = new HashMap();
        parameterMap.put("value", valueObj);
        parameterMap.put("type", DaoTypes.getSQLType(typeStr));
        paramsMapList.add(parameterMap);
        return new StringBuffer(ele.getText());
    }

    public static StringBuffer handleRepeatElement(Element ele, Map params, List paramsMapList) {
        String keyStr = ele.getAttributeValue("key");
        if (keyStr == null) {
            throw new XQueryParseFailureException("repeat\u8981\u7d20\u306bkey\u5c5e\u6027\u304c\u5b58\u5728\u3057\u307e\u305b\u3093. element=" + ele.getName());
        }
        if (params == null || !params.containsKey(keyStr)) {
            if (ele.getAttributeValue("req") == null) {
                throw new XQueryParseFailureException("repeat\u8981\u7d20\u306breq\u5c5e\u6027\u304c\u5b58\u5728\u3057\u307e\u305b\u3093. element=" + ele.getName());
            }
            Boolean isRequired = Boolean.valueOf(ele.getAttributeValue("req"));
            if (isRequired.booleanValue()) {
                throw new XQueryParseFailureException(" repeat\u8981\u7d20\u306ereq\u5c5e\u6027\u304ctrue\u306a\u306e\u306b\u30d1\u30e9\u30e1\u30fc\u30bf\u304cMap\u306b\u5b58\u5728\u3057\u307e\u305b\u3093. key=" + keyStr);
            }
            return null;
        }
        StringBuffer sqlStrBuf = null;
        String typeStr = ele.getAttributeValue("type");
        Object valueObj = params.get(keyStr);
        if (valueObj.getClass().isArray()) {
            Object[] valueArray = (Object[])valueObj;
            if (valueArray.length == 0) {
                return null;
            }
            StringBuffer bindStr = new StringBuffer();
            for (int i = 0; i < valueArray.length; ++i) {
                if (i > 0) {
                    bindStr.append(", ?");
                } else {
                    bindStr.append("?");
                }
                Object setValue = valueArray[i];
                if (ele.getAttribute("like") != null) {
                    setValue = XQueryParseUtil.handleLikeAttribute(ele.getAttributeValue("like"), setValue);
                }
                HashMap<String, Object> parameterMap = new HashMap<String, Object>();
                parameterMap.put("value", setValue);
                parameterMap.put("type", DaoTypes.getSQLType(typeStr));
                paramsMapList.add(parameterMap);
            }
            sqlStrBuf = new StringBuffer(ele.getText().replaceFirst("[?]", bindStr.toString()));
        } else {
            sqlStrBuf = XQueryParseUtil.handleVarElement(ele, params, paramsMapList);
        }
        return sqlStrBuf;
    }

    public static StringBuffer handleBetweenElement(Element ele, Map params, List paramsMapList) {
        Object valueTo;
        String fromKey = ele.getAttributeValue("from");
        if (fromKey == null) {
            throw new XQueryParseFailureException("between\u8981\u7d20\u306bfrom\u5c5e\u6027\u304c\u5b58\u5728\u3057\u307e\u305b\u3093. element=" + ele.getName());
        }
        String toKey = ele.getAttributeValue("to");
        if (toKey == null) {
            throw new XQueryParseFailureException("between\u8981\u7d20\u306bto\u5c5e\u6027\u304c\u5b58\u5728\u3057\u307e\u305b\u3093. element=" + ele.getName());
        }
        if (params == null || !params.containsKey(fromKey) || !params.containsKey(toKey)) {
            if (ele.getAttributeValue("req") == null) {
                throw new XQueryParseFailureException("between\u8981\u7d20\u306breq\u5c5e\u6027\u304c\u5b58\u5728\u3057\u307e\u305b\u3093. element=" + ele.getName());
            }
            Boolean isRequired = Boolean.valueOf(ele.getAttributeValue("req"));
            if (isRequired.booleanValue()) {
                throw new XQueryParseFailureException(" repeat\u8981\u7d20\u306ereq\u5c5e\u6027\u304ctrue\u306a\u306e\u306b\u30d1\u30e9\u30e1\u30fc\u30bf\u304cMap\u306b\u5b58\u5728\u3057\u307e\u305b\u3093. from key=" + fromKey + " to key=" + toKey);
            }
            return null;
        }
        String sqlStr = null;
        Object valueFrom = params.get(fromKey);
        if (valueFrom != null && valueFrom.getClass().isArray()) {
            valueFrom = ((Object[])valueFrom)[0];
        }
        if ((valueTo = params.get(toKey)) != null && valueTo.getClass().isArray()) {
            valueTo = ((Object[])valueTo)[0];
        }
        HashMap parameterMap = new HashMap();
        parameterMap.put("value", valueFrom);
        parameterMap.put("type", null);
        paramsMapList.add(parameterMap);
        parameterMap = new HashMap();
        parameterMap.put("value", valueTo);
        parameterMap.put("type", null);
        paramsMapList.add(parameterMap);
        sqlStr = ele.getText();
        return new StringBuffer(sqlStr);
    }

    public static StringBuffer handleSwitchElement(Element ele, Map params, List paramsMapList) {
        Element defaultCase;
        String keyStr = ele.getAttributeValue("key");
        if (keyStr == null) {
            return null;
        }
        if (params != null && params.containsKey(keyStr)) {
            Object valueObj = params.get(keyStr);
            if (valueObj == null) {
                return null;
            }
            List children = ele.getChildren("case");
            Iterator it = children.iterator();
            while (it.hasNext()) {
                Element child = (Element)it.next();
                if (!((String)valueObj).equals(child.getAttributeValue("value"))) continue;
                return XQueryParseUtil.handleQueryElement(child, params, paramsMapList);
            }
        }
        if ((defaultCase = ele.getChild("default")) == null) {
            return null;
        }
        return XQueryParseUtil.handleQueryElement(defaultCase, params, paramsMapList);
    }

    public static StringBuffer handleListElement(Element ele, Map params, List paramsMapList) {
        StringBuffer sqlStrBuff = new StringBuffer();
        String joinStr = " ";
        if (ele.getAttribute("join") != null) {
            joinStr = " " + ele.getAttributeValue("join") + " ";
        }
        boolean isFirstContent = true;
        List contents = ele.getContent();
        Iterator it = contents.iterator();
        while (it.hasNext()) {
            StringBuffer buf;
            Object obj = it.next();
            if (obj instanceof String && XQueryParseUtil.isSpaceOnly((String)obj)) {
                sqlStrBuff.append((String)obj);
                continue;
            }
            if (obj instanceof Text && XQueryParseUtil.isSpaceOnly(((Text)obj).getText())) {
                sqlStrBuff.append(((Text)obj).getText());
                continue;
            }
            if (!(obj instanceof Element)) continue;
            StringBuffer eleStrBuf = null;
            String eleType = ((Element)obj).getName();
            if (eleType.equals("list")) {
                eleStrBuf = XQueryParseUtil.handleListElement((Element)obj, params, paramsMapList);
                if (eleStrBuf != null) {
                    buf = new StringBuffer();
                    buf.append(" ( ");
                    buf.append(eleStrBuf);
                    buf.append(" ) ");
                    eleStrBuf = buf;
                }
            } else if (eleType.equals("switch")) {
                eleStrBuf = XQueryParseUtil.handleSwitchElement((Element)obj, params, paramsMapList);
                if (eleStrBuf != null) {
                    buf = new StringBuffer();
                    buf.append(" ( ");
                    buf.append(eleStrBuf);
                    buf.append(" ) ");
                    eleStrBuf = buf;
                }
            } else if (eleType.equals("subquery")) {
                eleStrBuf = XQueryParseUtil.handleQueryElement((Element)obj, params, paramsMapList);
                if (eleStrBuf != null) {
                    buf = new StringBuffer();
                    buf.append(" ( ");
                    buf.append(eleStrBuf);
                    buf.append(" ) ");
                    eleStrBuf = buf;
                }
            } else if (eleType.equals("const")) {
                eleStrBuf = XQueryParseUtil.handleConstElement((Element)obj, params, paramsMapList);
            } else if (eleType.equals("var")) {
                eleStrBuf = XQueryParseUtil.handleVarElement((Element)obj, params, paramsMapList);
            } else if (eleType.equals("repeat")) {
                eleStrBuf = XQueryParseUtil.handleRepeatElement((Element)obj, params, paramsMapList);
            } else if (eleType.equals("between")) {
                eleStrBuf = XQueryParseUtil.handleBetweenElement((Element)obj, params, paramsMapList);
            } else {
                throw new XQueryParseFailureException("\u8981\u7d20\u540d\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093. element=" + ((Element)obj).getName());
            }
            if (eleStrBuf == null) continue;
            if (isFirstContent) {
                sqlStrBuff.append(" ").append(eleStrBuf);
                isFirstContent = false;
                continue;
            }
            sqlStrBuff.append(joinStr).append(eleStrBuf);
        }
        if (XQueryParseUtil.isSpaceOnly(sqlStrBuff.toString())) {
            return null;
        }
        return sqlStrBuff;
    }

    public static StringBuffer handleWhereElement(Element ele, Map params, List paramsMapList) {
        StringBuffer sqlStrBuff;
        if (ele.getAttribute("join") == null) {
            Attribute attr = new Attribute("join", "AND");
            ele.setAttribute(attr);
        }
        if ((sqlStrBuff = XQueryParseUtil.handleListElement(ele, params, paramsMapList)) != null) {
            StringBuffer buf = new StringBuffer("WHERE ");
            buf.append(sqlStrBuff);
            sqlStrBuff = buf;
        }
        return sqlStrBuff;
    }

    public static Object handleLikeAttribute(String likeStr, Object valueObj) {
        if (valueObj instanceof String) {
            if ("%?%".equals(likeStr)) {
                StringBuffer buf = new StringBuffer();
                buf.append("%");
                buf.append((String)valueObj);
                buf.append("%");
                return buf.toString();
            }
            if ("?%".equals(likeStr)) {
                StringBuffer buf = new StringBuffer();
                buf.append((String)valueObj);
                buf.append("%");
                return buf.toString();
            }
            if ("%?".equals(likeStr)) {
                StringBuffer buf = new StringBuffer();
                buf.append("%");
                buf.append((String)valueObj);
                return buf.toString();
            }
        }
        return valueObj;
    }

    public static boolean isSpaceOnly(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char checkChar = str.charAt(i);
            if (checkChar == ' ' || checkChar == '\u3000' || checkChar == '\n' || checkChar == '\r' || checkChar == '\t') continue;
            return false;
        }
        return true;
    }
}

