/*
 * Decompiled with CFR 0.152.
 */
package robbie.dao;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import robbie.dao.DaoSysException;
import robbie.dao.DaoUtil;
import robbie.dao.Query;

public class BaseDao
implements Serializable {
    private static final long serialVersionUID = -3734013538684469448L;

    protected void closeConnection(Connection conn) throws SQLException {
        if (conn != null) {
            conn.close();
        }
    }

    protected boolean isClosed(Connection conn) throws SQLException {
        if (conn != null) {
            return conn.isClosed();
        }
        return false;
    }

    protected void setAutoCommit(Connection conn, boolean isAutoCommit) throws SQLException {
        if (!this.isClosed(conn)) {
            conn.setAutoCommit(isAutoCommit);
        }
    }

    protected void commit(Connection conn) throws SQLException {
        if (!this.isClosed(conn)) {
            conn.commit();
        }
    }

    protected void rollback(Connection conn) throws SQLException {
        if (!this.isClosed(conn)) {
            conn.rollback();
        }
    }

    protected List executeQuery(Connection conn, Query query) throws SQLException {
        List list;
        if (conn == null) {
            throw new IllegalArgumentException("Connection\u304cNULL\u3067\u3059.");
        }
        if (query == null) {
            throw new IllegalArgumentException("Query\u30d1\u30e9\u30e1\u30fc\u30bf\u304cNULL\u3067\u3059.");
        }
        PreparedStatement sts = null;
        ResultSet rs = null;
        try {
            sts = this.openStatement(conn, query.getSQLString());
            rs = this.openQuery(sts, query.getBindParametersMapList());
            list = DaoUtil.resultSetToMapList(rs);
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.closeQuery(sts, rs);
            throw throwable;
        }
        this.closeQuery(sts, rs);
        return list;
    }

    protected Object[][] executeQueryForArray(Connection conn, Query query) throws SQLException {
        Object[][] objectArray;
        if (conn == null) {
            throw new IllegalArgumentException("Connection\u304cNULL\u3067\u3059.");
        }
        if (query == null) {
            throw new IllegalArgumentException("Query\u30d1\u30e9\u30e1\u30fc\u30bf\u304cNULL\u3067\u3059.");
        }
        PreparedStatement sts = null;
        ResultSet rs = null;
        try {
            sts = this.openStatement(conn, query.getSQLString());
            rs = this.openQuery(sts, query.getBindParametersMapList());
            objectArray = DaoUtil.resultSetToArray(rs);
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.closeQuery(sts, rs);
            throw throwable;
        }
        this.closeQuery(sts, rs);
        return objectArray;
    }

    protected List executeQueryForBeans(Connection conn, Query query) throws SQLException {
        List list;
        if (conn == null) {
            throw new IllegalArgumentException("Connection\u304cNULL\u3067\u3059.");
        }
        if (query == null) {
            throw new IllegalArgumentException("Query\u30d1\u30e9\u30e1\u30fc\u30bf\u304cNULL\u3067\u3059.");
        }
        if (query.getReslutClass() == null) {
            throw new IllegalArgumentException("JavaBeans\u5909\u63db\u5148\u306e\u30af\u30e9\u30b9\u304cNULL\u3067\u3059.");
        }
        PreparedStatement sts = null;
        ResultSet rs = null;
        try {
            sts = this.openStatement(conn, query.getSQLString());
            rs = this.openQuery(sts, query.getBindParametersMapList());
            list = DaoUtil.resultSetToBeansList(query.getReslutClass(), rs);
            Object var6_6 = null;
        }
        catch (Exception ex) {
            try {
                if (ex instanceof SQLException) {
                    throw (SQLException)ex;
                }
                throw new DaoSysException(ex);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.closeQuery(sts, rs);
                throw throwable;
            }
        }
        this.closeQuery(sts, rs);
        return list;
    }

    protected List executeQueryForDynaBean(Connection conn, Query query) throws SQLException {
        List list;
        if (conn == null) {
            throw new IllegalArgumentException("Connection\u304cNULL\u3067\u3059.");
        }
        if (query == null) {
            throw new IllegalArgumentException("Query\u30d1\u30e9\u30e1\u30fc\u30bf\u304cNULL\u3067\u3059.");
        }
        PreparedStatement sts = null;
        ResultSet rs = null;
        try {
            sts = this.openStatement(conn, query.getSQLString());
            rs = this.openQuery(sts, query.getBindParametersMapList());
            list = DaoUtil.resultSetToDynaBeanList(rs);
            Object var6_6 = null;
        }
        catch (Exception ex) {
            try {
                if (ex instanceof SQLException) {
                    throw (SQLException)ex;
                }
                throw new DaoSysException(ex);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.closeQuery(sts, rs);
                throw throwable;
            }
        }
        this.closeQuery(sts, rs);
        return list;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int executeUpdate(Connection conn, Query query) throws SQLException {
        if (conn == null) {
            throw new IllegalArgumentException("Connection\u304cNULL\u3067\u3059.");
        }
        if (query == null) {
            throw new IllegalArgumentException("Query\u30d1\u30e9\u30e1\u30fc\u30bf\u304cNULL\u3067\u3059.");
        }
        int count = 0;
        PreparedStatement sts = null;
        try {
            String sqlStr = query.getSQLString();
            List params = query.getBindParametersMapList();
            sts = this.openStatement(conn, sqlStr);
            this.bindParameters(sts, params);
            count = sts.executeUpdate();
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.closeStatement(sts);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        this.closeStatement(sts);
        return count;
    }

    protected PreparedStatement openStatement(Connection conn, String sql) throws SQLException {
        if (conn == null) {
            throw new IllegalArgumentException("Connection\u304cNULL\u3067\u3059.");
        }
        if (sql == null) {
            throw new IllegalArgumentException("SQL\u6587\u5b57\u5217\u304cNULL\u3067\u3059.");
        }
        return conn.prepareStatement(sql);
    }

    protected ResultSet openQuery(PreparedStatement sts, List params) throws SQLException {
        if (sts == null) {
            throw new IllegalArgumentException("Statement\u304cNULL\u3067\u3059.");
        }
        this.bindParameters(sts, params);
        return sts.executeQuery();
    }

    protected void bindParameters(PreparedStatement sts, List params) throws SQLException {
        if (sts == null) {
            throw new IllegalArgumentException("Statement\u304cNULL\u3067\u3059.");
        }
        if (params != null) {
            int i = 1;
            Iterator it = params.iterator();
            while (it.hasNext()) {
                Map map = (Map)it.next();
                Object obj = map.get("value");
                Integer type = (Integer)map.get("type");
                if (obj != null) {
                    sts.setObject(i, obj);
                } else if (type == null) {
                    sts.setNull(i, 12);
                } else {
                    sts.setNull(i, type);
                }
                ++i;
            }
        }
    }

    protected void closeQuery(PreparedStatement sts, ResultSet rs) throws SQLException {
        this.closeResultSet(rs);
        this.closeStatement(sts);
    }

    protected void closeStatement(PreparedStatement sts) throws SQLException {
        if (sts != null) {
            sts.close();
        }
    }

    protected void closeResultSet(ResultSet rs) throws SQLException {
        if (rs != null) {
            rs.close();
        }
    }
}

