/*
 * Copyright 2004-2006 Robbie.JP
 */
package robbie.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

/**
 * JDomXMLLoaderNX<p>
 * w肵InputStreamJDOMElementload܂B
 */
public class JdomXmlLoader {
    
    private JdomXmlLoader() {
        // CX^XȂ
    }
    
    /**
     * w肳ꂽXMLInputStreamElementCX^X擾B<p>
     * @param inputStream w肳ꂽXMLInputStream
     * @param validate XMĽ؂{邩ǂ
     * @exception IOException
     * @exception JDOMException
     * @return XMLt@CrootElement
     */
    public static Element load(InputStream inputStream, boolean validate) 
            throws IOException, JDOMException {
        
        SAXBuilder builder = new SAXBuilder(validate);
        Document document = null;
        BufferedInputStream bInputStream = null;
        try {
            if (inputStream instanceof BufferedInputStream) {
                bInputStream = (BufferedInputStream)inputStream;
            } else {
                bInputStream = new BufferedInputStream(inputStream);
            }
            // DocumentIuWFNg̍쐬
            document = builder.build( bInputStream);
        } finally {
            try {
                if (bInputStream != null) {
                    bInputStream.close();
                    inputStream = null;
                }
            } finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        // Element̎o
        return document.getRootElement();
    }
    
    /**
     * w肳ꂽXMLInputStreamElementCX^X擾B<p>
     * XMLvalidate͕K{ōsȂ܂B
     * @param inputStream xmlpath
     * @exception IOException
     * @exception JDOMException
     * @return XMLt@CrootElement
     */
    public static Element load(InputStream inputStream) 
            throws IOException, JDOMException {
        return load(inputStream, true);
    }
}
