/*
 * Copyright 2004-2006 Robbie.JP
 */
package robbie.dao.x;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;

import robbie.dao.DaoSysException;
import robbie.dao.DbConnectionUtil;

/**
 * JdbcResourceNXB<p>
 * typeJDBC̏ꍇDBResourceB
 */
public class JdbcResource implements XDbResource {
    
    private static final long serialVersionUID = 1898964070539584048L;
    
    private JdbcConnectionProxy proxy = new JdbcConnectionProxy();
    
    /** JDBC̐ݒ */
    protected Properties env = null;
    
    /**
     * f[^x[X̐ڑvpeBw肵ăCX^X쐬܂B<p>
     * @param env
     */
    public JdbcResource(Properties env) {
        if (env == null) {
            throw new IllegalArgumentException("JDBCڑvpeBNULLł.");
        }
        this.env = env;
    }
    
    /**
     * RlNVԂB<p>
     * Xbh̒ŁAConnection擾ĂAcloseĂȂ΁A
     * XbhŃv[ĂConnectionԂ܂B
     * @return ConnectionIuWFNg
     */
    public Connection getConnection() {
        
        try {
            Connection conn = proxy.getConnection();
            if (conn == null || conn.isClosed()) {
                conn = new JdbcConnectionWrapper(DbConnectionUtil.getConnection(env), false);
                proxy.setConnection(conn);
            }
            return conn;
        } catch(Exception ex) {
            throw new DaoSysException("RlNV̎擾Ɏs܂.", ex);
        }
    }
    
    /**
     * ThreadɃRlNVv[Ăꍇɂ̓N[Y܂B<p>
     * ̃\bhŎĂ鏈ThreadɊ֘AĂConnectionĂ܂B
     * ̃NXgɂ̓[JϐƂĂConnection͕ێĂ܂B
     */
    public void release() {
        
        JdbcConnectionWrapper wrapper = (JdbcConnectionWrapper)proxy.getConnection();
        if (wrapper != null) {
            try {
                wrapper.closeConnection();
            } catch(SQLException ex) {
                //ȂB
            }
        }
    }
    
    /**
     * JdbcConnectionProxyCX^X擾܂B<p>
     * @return@JdbcConnectionProxyCX^X
     */
    protected JdbcConnectionProxy getJdbcConnectionProxy() {
        return proxy;
    }
    
    /**
     * toString()̃I[oChB<p>
     * @return ̃CX^X̕\L
     */
    public String toString() {
        return "JDBC PROPERTY=" + env;
    }
}
