/*
 * Copyright 2004-2006 Robbie.JP
 */
package robbie.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;



/**
 * w肵NX̃CX^X𐶐t@NgNXB<p>
 */
public class InstanceFactory {

    private static final Log LOG = LogFactory.getLog(InstanceFactory.class);
    
    /**
     * w肵NX̃CX^X𐶐B<p>
     * @param className 쐬CX^X̃NX
     * @return 쐬CX^X
     */
    public static Object createInstance(String className) {

        try {
            return Class.forName(className).newInstance();
        } catch(ClassNotFoundException ex) {
            LOG.debug("Not faund class=" + className + "] in default class loader.");
            LOG.debug("Try find class in Thread.currentThread().getContextClassLoader().");
            
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            return createInstance(className, loader);
        } catch(Exception ex) {
            LOG.debug("find class failure.");
            throw new InstanceCreateFailureException("InstanceFactory::createInstance() failed", ex);
        }
    }

    /**
     * w肵NX̃CX^Xw肵NX[_ŐB<p>
     * @param className 쐬CX^X̃NX
     * @param loader NX[_
     * @return 쐬CX^X
     */
    public static Object createInstance(String className, ClassLoader loader) {
 
        try {
            if (loader == null) {
                return createInstance(className);
            }
            return Class.forName(className, true, loader).newInstance();
        } catch (Exception ex) {
            LOG.debug("find class failure.");
            if(ex instanceof InstanceCreateFailureException) {
                throw (InstanceCreateFailureException)ex;
            }
            throw new InstanceCreateFailureException("InstanceFactory::createInstance() failed", ex);
        }
    }
}
