/*
 * Copyright 2004-2006 Robbie.JP
 */
package robbie.dao.x;

import java.io.Serializable;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import org.jdom.Element;

import robbie.dao.DaoUtil;
import robbie.dao.Query;
import robbie.util.InstanceFactory;

/**
 * XQueryFactoryNX.<p>
 */
public class XQueryFactory implements Serializable {

    /** XQuerỹNX */
    protected String xQueryClassName = XQuery.class.getName();
    
    /** query-listosqlvfMap */
    protected Map sqlMap = null;

    /**
     * query-listElementsqlMap쐬B<p>
     * ͓̏܂B
     * @param queryElement query-listElement
     */
    public void configure(Element queryElement) {
        
        Map map = new HashMap();
        List eleList = queryElement.getChildren("query");
        for (Iterator it=eleList.iterator(); it.hasNext(); ) {
            Element child = (Element)it.next();
            map.put(child.getAttributeValue("id"), child);
        }
        this.sqlMap = map;
    }
    
    /**
     * w肳ꂽIDƃp[^MapQueryIuWFNgԂ܂B<p>
     * @param id
     * @param params
     * @return Query
     */
    public Query createQueryInstance(String id, Map params) {
        
        XQuery query = (XQuery)InstanceFactory.createInstance(this.xQueryClassName);
        query.setElement((Element)sqlMap.get(id));
        query.setParameters(params);
        query.configure();
        return query;
    }
    
    /**
     * w肳ꂽIDJavaBeansQueryIuWFNgԂ܂B<p>
     * @param id
     * @param bean
     * @return Query
     */
    public Query createQueryInstance(String id, Object bean) {
        
        Map params = null;
        try {
            params = DaoUtil.beansToMap(bean);
        } catch (Exception ex) {
            // Ȃ
        }
        return createQueryInstance(id, params);
    }
}
