/*
 * Copyright 2004-2006 Robbie.JP
 */
package robbie.dao.x;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import org.jdom.Element;

import robbie.dao.DbConnectionUtil;

/**
 * XDbResourceFactoryNX.<p>
 */
public class XDbResourceFactory {

    /** DbResourcẽCX^XێMap */
    protected Map resourceMap = new HashMap();
    
    /**
     * ftHgRXgN^B<p>
     */
    public XDbResourceFactory() {
        // Ȃ
    }
    
    /**
     * w肵IDDbResourcẽCX^XԂ܂B<p>
     * @param id DbResourcew肷ID
     * @return DbResourcẽCX^X
     */
    public XDbResource getDbResource(String id) {
        return (XDbResource)resourceMap.get(id);
    }
    
    /**
     * ݒt@CDbResourcẽCX^X쐬ێ܂B<p>
     * @param resourceListElement Resource`ȂElement
     */
    public void configure(Element resourceListElement) {
        
        List list = resourceListElement.getChildren("resource");
        if (list != null && list.size() > 0) {
            Map map = new HashMap();
            for (Iterator it=list.iterator(); it.hasNext(); ) {
                Element ele = (Element)it.next();
                String id = ele.getAttributeValue("id");
                String type = ele.getAttributeValue("type");
                map.put(id, createXDbResource(type, ele));
            }
            this.resourceMap = map;
        }
    }
    
    /**
     * resoucevfDbResourcẽCX^X쐬܂B<p>
     * {IɂXDbResourceFactory͊g̕Kv͂܂񂪁AƎ̕@
     * Connection擾Kvꍇɂ́Ã\bhgĂB
     * @param type Connection̎擾@TYPE
     * @param ele resoucevfElement
     * @return XDbResourceCX^X
     */
    protected XDbResource createXDbResource(String type, Element ele) {
        
        XDbResource resource = null;
        if ("DataSource".equals(type)) {
            
            // Server JDBCiDataSourcejpXML\[XǗ
            String jndiName = ele.getChild("jndi-name").getText();
            resource =  new DataSourceResource(jndiName);
            
        } else if ("JDBC".equals(type)) {
            
            // Local JDBCpXML\[XǗ
            Properties env = new Properties();
            env.put(DbConnectionUtil.DRIVER_CLASS_NAME_KEY, ele.getChild("driver").getText());
            env.put(DbConnectionUtil.SERVER_URL_KEY, ele.getChild("url").getText());
            env.put(DbConnectionUtil.USERNAME_KEY, ele.getChild("username").getText());
            env.put(DbConnectionUtil.PASSWORD_KEY, ele.getChild("password").getText());
            resource = new JdbcResource(env);
            
        } else if ("JDBC-ODBC".equals(type)) {
            
            // JDBC-ODBCpXML\[XǗ
            String sourceName = ele.getChild("odbc-data-source").getText();
            resource = new JdbcOdbcResource(sourceName);
            
        } else {
            throw new XDaoException("Resource type not mattched. type=" + type);
        }
        return resource;
    }
}
