/*
 * Copyright 2004-2006 Robbie.JP
 */
package robbie.dao.x;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.jdom.Element;

import robbie.util.InstanceFactory;
import robbie.util.JdomXmlLoadHelper;

/**
 * XDAOFactoryNXB<p>
 * w肳ꂽt@CɊÂāADAOCX^X𐶐܂B
 */
public class XDaoFactory implements Serializable {
    
    private static final Log LOG = LogFactory.getLog(XDaoFactory.class);
    
    /** XQueryFactoryClass */
    protected String xQueryFactoryClassName = XQueryFactory.class.getName();
    
    /** XDbResourceFactoryClass */
    protected String xDBResourceFactoryClassName = XDbResourceFactory.class.getName();
    
    /** t@CFilepath */
    protected String filepath = null;
    
    /** XQueryFactorỹCX^X */
    protected XQueryFactory queryFactory = null;
    
    /** XDBResourceFactorỹCX^X */
    protected XDbResourceFactory resourceFactory = null;
    
    /** DAÕNXǗMap */
    protected Map daoNameMap = null;
    
    /** DAOƗpDbResource̊֘AǗMap */
    protected Map daoResRefMap = null;
    
    // init inputStream 1970/1/1 00:00:00:000
    /** t@C̍XV */
    protected long lastModifiedTimestamp = 0;
    
    /** XML̃[hɌ؂sBftHg͍sȂ */
    protected boolean isValidate = false;
    
    /**
     * ftHgRXgN^B<>
     */
    private XDaoFactory() {
        // ȂB
    }

    /**
     * RXgN^B<p>
     * t@CǍݏȂB<p>
     * @param filepath
     */
    public XDaoFactory(String filepath) {
        
        try {
            configure(new FileInputStream(filepath));
            this.filepath = filepath;
            this.lastModifiedTimestamp = (new File(filepath)).lastModified();
        }catch(FileNotFoundException ex) {
            throw new XDaoException("file not found. filepath = "+ filepath, ex);
        }
    }
    
    /**
     * RXgN^B<p>
     * w肵InputStream琧t@CǍݏȂB<p>
     * @param inputStream w肵InputStream
     */
    public XDaoFactory(InputStream inputStream) {
        configure(inputStream);
    }
    
    /**
     * DAOCX^X擾B<p>
     * VKDAO쐬Ƃ́A̎̍ŐV̐XML̓e
     * fB
     * @param id DAOID
     * @param loader 쐬CX^XClassLoader
     * @return xDAOCX^X
     */
    public XDao createDaoInstance(String id, ClassLoader loader) {
        
        reconfigureIfNeeded();
        if (!daoNameMap.containsKey(id)) {
            throw new XDaoException("id =[" + id + "] not definition in config xml file.");
        }
        Object obj = InstanceFactory.createInstance((String)daoNameMap.get(id), loader);
        XDao dao = (XDao)obj;
        dao.setQueryFactory(this.queryFactory);
        dao.setResource(this.resourceFactory.getDbResource((String)daoResRefMap.get(id)));
        dao.configure();
        return dao;
    }
    
    /**
     * DAOCX^X擾B<p>
     * VKDAO쐬Ƃ́A̎̍ŐV̐XML̓e
     * fB
     * @param id DAOID
     * @return xDAOCX^X
     */
    public XDao createDaoInstance(String id) {
        return createDaoInstance(id, null);
    }
    
    /**
     * SĂ̐XV܂B<p>
     * ͓̏Ă܂Bgۂɂ́A
     * XbhZ[tɒӂĂB
     * @param inputStream RootElementǂݍނ߂InputStream
     */
    protected void configure(InputStream inputStream) {
        
        Element root = loadRootElemet(inputStream);
        configureQueryFactory(root);
        configureResourceFactory(root);
        conifgureDAOMap(root);
    }
    
    /**
     * t@C̃^CX^vXVĂ΁A[hB<p>
     * t@C̑InputStreamǂݍ܂ꂽꍇɂ͉ȂB
     */
    protected void reconfigureIfNeeded() {
        
        if(filepath != null) {
            long nowLastModifiedTimestamp = (new File(filepath)).lastModified();
            if (nowLastModifiedTimestamp > lastModifiedTimestamp) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("reload config file." + 
                        " filepath=" + this.filepath +
                        " Old last timestamp = " + new Date(lastModifiedTimestamp) + 
                        " New last timestamp = " + new Date(nowLastModifiedTimestamp));
                }
                try{
                    configure(new FileInputStream(filepath));
                    this.lastModifiedTimestamp = nowLastModifiedTimestamp;
                } catch(FileNotFoundException ex) {
                    throw new XDaoException("file not found. filepath=" + filepath, ex);
                }
            }
        }
    }
    
    /**
     * InputStream琧XMLElementǂݍ݂܂B<p>
     * @param inputStream RootElementǂݍނ߂InputStream
     * @return rootElement
     */
    protected Element loadRootElemet(InputStream inputStream) {
        
        try {
            return JdomXmlLoadHelper.load(inputStream, isValidate);
        } catch(Exception ex) {
            throw new XDaoException("catch exception, when load config xml files.", ex);
        }
    }
    
    /**
     * XQueryFactoryNX쐬܂B<p>
     * @param root XMLrootElement
     */
    protected void configureQueryFactory(Element root) {
        
        
        XQueryFactory factory = 
            (XQueryFactory)InstanceFactory.createInstance(this.xQueryFactoryClassName);
        factory.configure(root.getChild("query-list"));
        this.queryFactory = factory;
    }
    
    /** 
     * XDBResourceFactoryNX쐬܂B<p>
     * @param root XMLrootElement
     */
    protected void configureResourceFactory(Element root) {
        
        XDbResourceFactory factory = 
            (XDbResourceFactory)InstanceFactory.createInstance(this.xDBResourceFactoryClassName);
        factory.configure(root.getChild("resource-list"));
        this.resourceFactory = factory;
    }
    
    /**
     * DAÕNXƑΏۃ\[XMapt@C[hB<p>
     * @param root XMLrootElement
     */
    protected void conifgureDAOMap(Element root) {
        
        Element resourceList = root.getChild("dao-list");
        List list = resourceList.getChildren("dao");
        if (list != null && list.size() > 0) {
            Map nameMap = new HashMap();
            Map refMap = new HashMap();
            for (Iterator it=list.iterator(); it.hasNext(); ) {
                Element ele = (Element)it.next();
                String id = ele.getAttributeValue("id");
                String calssName = ele.getChild("class").getText();
                String refResoauce = ele.getChild("resource-ref").getText();
                nameMap.put(id, calssName);
                refMap.put(id, refResoauce);
            }
            this.daoNameMap = nameMap;
            this.daoResRefMap = refMap;
        }
    }
}