/*
 * Copyright 2004-2006 Robbie.JP
 */
package robbie.dao.x;

import java.util.Map;
import java.util.List;

import java.sql.SQLException;

import robbie.dao.BaseDao;

/**
 * XDAONXB<p>
 * <pre>
 * ̃NX́AXMLt@Cɒ`ꂽASQLƃf[^x[X\[XgpāA
 * f[^x[XANZXsȂDAONXłBXML`𗘗pꍇɂ́A
 * ̃NXpNXƖvɎĂB
 * ܂ÃNXɂ̓ftHgŁAPgUNV̌ƍXV݂̂Ă܂B
 * gsȂꍇɂ́ÃNXpNX쐬AXML&lt;class-name&gt;
 * NXƗp郊\[Xݒ肵ĂB
 * </pre>
 * @see robbie.dao.BaseDao
 * @see robbie.dao.x.XQueryFactory
 * @see robbie.dao.x.XDbResource
 */
public class XDao extends BaseDao {

    /**
     * XQueryFactoryNX̃CX^XB<p>
     * <pre>
     * ̕ϐ𗘗pāAsSQLCX^X擾܂B
     * TuNXł͈ȉ̂悤ɂāASQLCX^X擾
     * gsȂĂB
     * 
     * Query query = queryFactory.createSQLInstance(id, params);
     * 
     * </pre>
     * @see robbie.dao.Query
     * @see XQueryFactory#createQueryInstance(String, Map)
     */
    protected XQueryFactory queryFactory = null;
    
    /**
     * XDbResourceNX̃CX^XB<p>
     * <pre>
     * ̕ϐ𗘗pāAf[^x[XւConnection擾܂B
     * TuNXł͈ȉ̂悤ɂāAConnectionCX^X擾
     * gsȂĂB
     * 
     * java.sql.Connection conn = resource.getConnection();
     * 
     * ܂ADAOs\ɂꍇɂ́Â悤Ɏƕ֗łB
     * 
     * setConnection(resource.getConnection());
     * 
     * </pre>
     * @see XDbResource#getConnection()
     */
    protected XDbResource resource = null;
    
    /**
     * O̍XVŔSQLExceptionB<p>
     */
    protected SQLException exception = null;
    
    /**
     * XQueryFactoryCX^XZbg܂B<p>
     * @param queryFactory XSQLFactoryCX^X
     */
    public void setQueryFactory(XQueryFactory queryFactory) {
        this.queryFactory = queryFactory;
    }

    /**
     * XDbResourceCX^XZbg܂B<p>
     * @param resource XmlDBResourceCX^X
     */
    public void setResource(XDbResource resource) {
        this.resource = resource;
    }
    
    /**
     * O̍XVŎ擾SQLExceptionԂ܂B<p>
     * @return OɎ擾SQLException
     */
    public SQLException getSQLException() {
        return exception;
    }
    
    /**
     * configure()\bh̃I[oChB<p>
     * XDaoł͉Ă܂B
     * ̃\bh͏ƂXDaoCX^X쐬ɌĂяoĂ܂B
     * XDaõTuNXŏKvȏꍇ΁AI[oChĎgpĂB
     */
    public void configure() {
        // Ȃ
    }
    
    /**
     * ₢킹sAʂMapListŕԂ܂B<p>
     * <pre>
     * RlNV擾AsListԂA
     * RlNVclose܂B
     * </pre>
     * @param id queryid
     * @param params p[^Map
     * @return ʂMapList
     */
    public List query(String id, Map params) {
        
        try{
            setConnection(resource.getConnection());
            return executeQuery(queryFactory.createQueryInstance(id, params));
        } catch(Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new XDaoException("catch exception.", ex);
        } finally {
            try {
                closeConnection();
            } catch(Exception ex) {
                //throw new XDaoException("", ex);
            }
        }
    }
    
    /**
     * ₢킹sAʂObject[][]ŕԂ܂B<p>
     * Object[0][*]̓J̃wb_ɂȂ܂B
     * f[^gpꍇɂ́AObject[1][*]gpĂ
     * @param id queryid
     * @param params p[^Map
     * @return ʂ2z
     */
    public Object[][] queryForArray(String id, Map params) {
        
        try{
            setConnection(resource.getConnection());
            return executeQueryForArray(queryFactory.createQueryInstance(id, params));
        } catch(Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new XDaoException("catch exception.", ex);
        } finally {
            try {
                closeConnection();
            } catch(Exception ex) {
                //throw new XDaoException("", ex);
            }
        }
    }
    
    /**
     * ₢킹sAʂJavaBeansListŕԂ܂B<p>
     * @param id queryid
     * @param params p[^Map
     * @param beanClass ϊBeanClassIuWFNg
     * @return JavaBeansList
     */
    public List queryForBeans(String id, Map params, Class beanClass) {
        
        try{
            setConnection(resource.getConnection());
            return executeQueryForBeans(queryFactory.createQueryInstance(id, params), beanClass);
        } catch(Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new XDaoException("catch exception.", ex);
        } finally {
            try {
                closeConnection();
            } catch(Exception ex) {
                //throw new XDaoException("", ex);
            }
        }
    }
    
    /**
     * XVs܂B<p>
     * <pre>
     * ̃\bhSQLExceptionꍇɂ́A-1Ԃ܂B
     * -1Ԃꂽꍇɂ͂SQLExceptionoϐƂĕێ܂̂ŁA
     * KvȏꍇɂgetSQLException()炻SQLException擾邱Ƃ\łB
     * ܂Ã\bhJDBCgUNV̏ꍇɂ́A1gUNVƂ
     * s邱ƂɒӂĉBAJTÃgUNVReił́A
     * Reî̃gUNVD悳܂B
     * </pre>
     * @param id queryid
     * @param params p[^Map
     * @return XVASQLExceptionꍇɂ-1
     */
    public int update(String id, Map params) {
        
        try{
            setConnection(resource.getConnection());
            return executeUpdate(queryFactory.createQueryInstance(id, params));
        } catch(SQLException ex) {
            this.exception = ex;
            return -1;
        } catch(Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new XDaoException("catch exception.", ex);
        } finally {
            try {
                closeConnection();
            } catch(Exception ex) {
                //throw new XDaoException("", ex);
            }
        }
    }
    
    /**
     * JavaBeansoChϐMap쐬čXVs܂B<p>
     * <pre>
     * ̃\bhSQLExceptionꍇɂ́A-1Ԃ܂B
     * -1Ԃꂽꍇɂ͂SQLExceptionoϐƂĕێ܂̂ŁA
     * KvȏꍇɂgetSQLException()炻SQLException擾邱Ƃ\łB
     * </pre>
     * @param id queryid
     * @param beans oChϐƂȂJavaBeans
     * @return XVASQLExceptionꍇɂ-1
     */
    public int update(String id, Object beans) {
        
        try {
            setConnection(resource.getConnection());
            return executeUpdate(queryFactory.createQueryInstance(id, beans));
        } catch(Exception ex) {
            if (ex instanceof RuntimeException) {
                throw(RuntimeException)ex;
            }
            throw new XDaoException("catch exception.", ex);
        }
    }
}
