/*
 * Copyright 2004-2006 Robbie.JP
 */
package robbie.dao.s;

import java.util.List;
import java.util.Properties;

import java.sql.SQLException;

import robbie.dao.BaseDao;
import robbie.dao.DaoSysException;
import robbie.dao.DbConnectionUtil;
import robbie.dao.Query;


/**
 * BaseDAOpăf[^x[XɊȈՓIɐڑDAONXB<p>
 */
public class SDao extends BaseDao {

    private Properties dbAccessProperties = null;
    
    /**
     * f[^x[XڑvpeBԂB<p>
     * @return f[^x[XڑvpeB
     */
    public Properties getDbAccessProperties() {
        return dbAccessProperties;
    }
    
    /**
     * f[^x[XڑvpeBZbgB<p>
     * @param props f[^x[XڑvpeB 
     */
    public void setDbAccessProperties(Properties props) {
        this.dbAccessProperties = props;
    }
    
    /**
     * f[^x[XāǍʂMapLisť`ŕԂB<p>
     * @param sql
     * @return 1R[h1MapƂčXVʂԂB
     * @throws SQLException
     */
    public List query(Query sql) throws SQLException {
        
        try{
            super.setConnection(DbConnectionUtil.getConnection(getDbAccessProperties()));
            return super.executeQuery(sql);
        } catch(Exception ex) {
            if (ex instanceof SQLException) {
                throw (SQLException)ex;
            }
            throw new DaoSysException(ex);
        } finally {
            super.closeConnection();
        }
    }
    
    /**
     * f[^x[XāǍʂ2ž`ŕԂB<p>
     * @param sql SQLCX^X
     * @return ʂłObject2z
     * @throws SQLException
     * @throws SQLException
     */
    public Object[][] queryForArray(Query sql) throws SQLException {
        
        try{
            super.setConnection(DbConnectionUtil.getConnection(getDbAccessProperties()));
            return super.executeQueryForArray(sql);
        } catch(ClassNotFoundException ex) {
            throw new DaoSysException(ex);
        } finally {
            super.closeConnection();
        }
    }
    
    /**
     * f[^x[XāǍʂJavaBeansListŕԂB<p>
     * @param sql SQLCX^X
     * @return ʂłJavaBeansList
     * @throws SQLException
     */
    public List queryForBeans(Query sql) throws SQLException {
        
        try{
            super.setConnection(DbConnectionUtil.getConnection(getDbAccessProperties()));
            return super.executeQueryForBeans(sql, null);
        } catch(ClassNotFoundException ex) {
            throw new DaoSysException(ex);
        } finally {
            super.closeConnection();
        }
    }
    
    /**
     * f[^x[XXVA̍XVԂB<p>
     * @param sql
     * @return XV
     * @throws SQLException XVɎsꍇthrow܂B
     */
    public int update(Query sql) throws SQLException {
        
        try {
            super.setConnection(DbConnectionUtil.getConnection(getDbAccessProperties()));
            return super.executeUpdate(sql);
        } catch(Exception ex) {
            if (ex instanceof SQLException) {
                throw (SQLException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw(RuntimeException)ex;
            }
            throw new DaoSysException(ex);
        } finally {
            super.closeConnection();
        }
    }
}
