/*
 * Copyright 2004-2006 Robbie.JP
 */
package robbie.dao;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

import javax.naming.NamingException;
import javax.sql.DataSource;

import robbie.util.JndiUtil;

/**
 * ConnectionADataSource񋟂郆[eBeBNXB
 */
public class DbConnectionUtil {

    private DbConnectionUtil() {}
    
    /** ڑMap̃T[ow肷KEYB<p> */
    public static final String DRIVER_CLASS_NAME_KEY = "driver.class.name";
    
    /** ڑMap̃T[ow肷KEYB<p> */
    public static final String PASSWORD_KEY = "password";
    
    /** ڑMap̃T[ow肷KEYB<p> */
    public static final String SERVER_URL_KEY = "server.url";
    
    /** ڑMap̃T[ow肷KEYB<p> */
    public static final String USERNAME_KEY = "username";

    /**
     * DriverManagerRlNV擾B<p>
     * \߁AhCoNXAURLA[UApX[hݒ肵A
     * MappӂKv܂BMapKEY͂̃NXstaticϐ
     * `Ă镶ɂȂ܂B
     * @param env
     * @return ConnectionCX^X
     * @throws ClassNotFoundException
     * @throws SQLException
     */
    public static Connection getConnection(Properties env) 
            throws ClassNotFoundException, SQLException {
        
        String driverName = (String)env.get(DbConnectionUtil.DRIVER_CLASS_NAME_KEY);
        Class.forName(driverName);
    
        String url = (String)env.get(DbConnectionUtil.SERVER_URL_KEY);
        String username = (String)env.get(DbConnectionUtil.USERNAME_KEY);
        String password = (String)env.get(DbConnectionUtil.PASSWORD_KEY);
        return DriverManager.getConnection(url, username, password);
    }

    /**
     * DriverManagerURL݂̂w肵ăRlNV擾B<p>
     * ()JDBC-ODBCubWɂConnection擾ŎgpB
     * @param driverName JDBChCo
     * @param url ڑURL
     * @return ConnectionIuWFNg
     * @throws ClassNotFoundException
     * @throws SQLException
     */
    public static Connection getConnection(String driverName, String url) 
            throws ClassNotFoundException, SQLException {
        
        Class.forName(driverName);
        return DriverManager.getConnection(url);
    }

    /**
     * DriverManagerURLƃvpeBw肵ăRlNV擾B<p>
     * @param driverName JDBChCo
     * @param url ڑURL
     * @param info vpeBiȂƂuserpassword͎w肷Kvj
     * @return ConnectionIuWFNg
     * @throws ClassNotFoundException
     * @throws SQLException
     */
    public static Connection getConnection(String driverName, String url, Properties info) 
            throws ClassNotFoundException, SQLException {
        
        Class.forName(driverName);
        return DriverManager.getConnection(url, info);
    }

    /**
     * f[^\[XRlNV擾܂B<p>
     * @param dsName
     * @return Connection
     * @exception NamingException
     * @exception SQLException
     */
    public static Connection getConnectionByDataSource(String dsName) 
            throws NamingException, SQLException {
        
        DataSource ds = DbConnectionUtil.getDataSource(dsName);
        return ds.getConnection();
    }

    /**
     * f[^\[X擾܂B<p>
     * @param dsName
     * @return DataSource
     * @exception NamingException
     */
    public static DataSource getDataSource(String dsName) throws NamingException {
        return (DataSource)JndiUtil.getJNDIValue(dsName, DataSource.class);
    }

}
