/*
 * Copyright 2004-2006 Robbie.JP
 */
package robbie.dao;

import java.util.List;
import java.util.Map;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.IntrospectionException;

import java.lang.reflect.InvocationTargetException;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import robbie.util.CollectionsUtil;

/**
 * f[^x[X̐ڑpNX֘Ã[eBeBNXB<p>
 */
public class DaoUtil {
    
    private static final Log LOGGER = LogFactory.getLog(DaoUtil.class);

    private DaoUtil(){}
    
    /**
     * ResultSet()MapList쐬܂B<p>
     * @param rs ĂȂResultSet
     * @return 1R[hPMapɓꂽList
     * @throws SQLException
     */
    public static  List resultSetToMapList(ResultSet rs) throws SQLException {
        
        List list = CollectionsUtil.createList();
        
        // Jz쐬
        ResultSetMetaData rsMetaData = rs.getMetaData();
        int columnCount = rsMetaData.getColumnCount();
        String[] columnNames = new String[columnCount];
        for(int i=0; i<columnCount; i++) {
            int name_i = i + 1;
            columnNames[i] = rsMetaData.getColumnName(name_i);
        }
        // ResultSet𗘗pĂ̌ʃXg쐬
        while(rs.next()) {
            Map columnMap = CollectionsUtil.createMap();
            for(int i=0; i<columnNames.length; i++) {
                int object_i = i + 1;
                columnMap.put(columnNames[i], rs.getObject(object_i));
            }
            list.add(columnMap);
        }
        // PR[h擾łȂnullԂ.
        if (list.size() == 0) {
            list = null;
        }
        return list;
    }
    
    /**
     * ResultSet()Object[][]쐬܂B<p>
     * 擪s̓wb_łB
     * @param rs ĂȂResultSet
     * @return 擪swb_ƂȂ2zB
     * @throws SQLException
     */
    public static Object[][] resultSetToArray(ResultSet rs) throws SQLException {
        
        List list = CollectionsUtil.createList();
        
        // Jz쐬
        ResultSetMetaData rsMetaData = rs.getMetaData();
        int columnCount = rsMetaData.getColumnCount();
        Object[] columnNames = new Object[columnCount];
        for(int i=0; i<columnCount; i++) {
            int name_i = i + 1;
            columnNames[i] = rsMetaData.getColumnName(name_i);
        }
        // Header
        list.add(columnNames);
        
        // ResultSet𗘗pĂ̌ʃXg쐬
        while(rs.next()) {
            Object[] columnValue = new Object[columnCount];
            for(int i=0; i<columnCount; i++) {
                int object_i = i + 1;
                columnValue[i] = rs.getObject(object_i);
            }
            // record
            list.add(columnValue);
        }
        
        // PR[h擾łȂnullԂ.
        if (list.size() <= 1) {
            return null;
        }
        
        // Object[] -> Object[][] ϊ
        Object[] before = list.toArray();
        Object[][] after = new Object[before.length][];
        for(int i=0; i<before.length; i++) {
            after[i] = (Object[])before[i];
        }
        return after;
    }
    
    /**
     * ResultSet̒lJavaBeansListɕϊB<p>
     * @param beanClass JavaBeasnsNX
     * @param rs ʂێResultSet
     * @return JavaBeansList
     * @throws Exception
     */
    public static final List resultSetToBeansList(Class beanClass, ResultSet rs) 
        throws Exception {
        
        List beanList = CollectionsUtil.createList();
        if (rs != null) {
            // JMap쐬
            ResultSetMetaData rsMetaData = rs.getMetaData();
            int columnCount = rsMetaData.getColumnCount();
            String[] columnNames = new String[columnCount];
            for(int i=0; i<columnNames.length; i++) {
                columnNames[i] = rsMetaData.getColumnName(i+1);
            }
            
            // PropertyDescriptorMap쐬
            BeanInfo info = Introspector.getBeanInfo(beanClass);
            PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
            if (descriptors == null) {
                // NULLԂꍇɂ͗vf̂ȂListԂ
                return beanList;
            }
            Map descriptorMap = CollectionsUtil.createMap();
            for(int i=0; i<descriptors.length; i++) {
                descriptorMap.put(descriptors[i].getName().toLowerCase(), descriptors[i]);
            }
            
            // ResultSet𗘗pĂ̌ʃXg쐬
            while(rs.next()) {
                Object bean = beanClass.newInstance();
                
                // Beans̃vpeB̐f[^Zbg
                for(int i=0; i<columnNames.length; i++) {
                    // JƈvvpeB݂Ȃ΃f[^̓ZbgȂ
                    String columnName = columnNameToPropertyName(columnNames[i]).toLowerCase();
                    if (descriptorMap.containsKey(columnName)) {
                        // \bh̓IȎs
                        PropertyDescriptor descriptor = 
                            (PropertyDescriptor)descriptorMap.get(columnName);
                        // Object̔z
                        Object arg = convertObjectIfNeeded(
                                descriptor.getPropertyType(),
                                descriptor.getName(), 
                                columnNames[i],
                                rs.getObject(i+1));
                        Object[] args = {arg};
                       
                        descriptor.getWriteMethod().invoke(bean, args);
                    }
                }
                beanList.add(bean);
            }
        }
        return beanList;
    }
    
    /**
     * JavaBeans̃vpeBMapɕϊB<p>
     * @param beans JavaBeansCX^X
     * @return vpeBKEYɂMap
     * @throws IntrospectionException
     * @throws IllegalAccessException
     * @throws InvocationTargetException
     */
    public static final Map beansToMap(Object beans) 
            throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        
        Class beansClass = beans.getClass();
        BeanInfo info = Introspector.getBeanInfo(beansClass);
        PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
        if (descriptors == null) {
            // NULLԂꍇɂNULLԂ
            return null;
        }
        Map map = CollectionsUtil.createMap();
        for(int i=0; i<descriptors.length; i++) {
            PropertyDescriptor descriptor = descriptors[i];
            Object[] args = {};
            map.put(descriptors[i].getName(), descriptor.getReadMethod().invoke(beans, args));
        }
        return map;
    }
    
    
    /**
     * J'_'݂ꍇA폜B
     * @param columnName J
     * @return '_'폜J
     */
    private static String columnNameToPropertyName(String columnName) {
        return columnName.replaceAll("[_]", "");
    }
    
    /**
     * Kvł΁Alf[^̌^ϊsB<p>
     * @param objClass ϊPropertyClass
     * @param propName ϊPropety
     * @param columnName f[^x[X̃J(SQL̃GCAX)
     * @param obj f[^x[Xϊf[^
     * @return ϊObject
     */
    private static final Object convertObjectIfNeeded(
            Class objClass,
            String propName, 
            String columnName, 
            Object obj) {
        
        // OƂāAł̓v~eBu^ւ̃f[^Zbg̃A}b`
        // ߂̏s܂B
        // 
        // i)   Zbg^Ashort, int, long, float, doublełAZbgf[^ 
        //      NumberC^tF[Xꍇɂ́AK؂Ȍ`̃bpNX
        //      Object֕ϊB
        // 
        // ii)  Zbg^AShort, Integer, Long, Float, DoublełAZbgf[^ 
        //      NumberC^tF[X邪AZbg^ƈvȂꍇɂ́A
        //      K؂Ȍ`̃bpNXObject֕ϊB
        // 
        // iii) Zbg^Abyte, char, booleanłAZbgf[^ 
        //      ̃bpNXłȂA܂NULLłꍇɂ́Av~eBu^
        //      l֕ϊB
        // 
        // ݌vƁȀ͏dȃVXeIȃoON\܂B
        // ]āAJavaBeans̐݌vA[LeNǵAf[^͈̔͂ƈvK؂
        // v~eBu^̃vpeBBean݌vȂĂ͂Ȃ܂B
        
        if (LOGGER.isDebugEnabled()) {
            String className = null;
            if (obj != null) {
                className = obj.getClass().getName();
            } else {
                className = "null";
            }
            LOGGER.debug(
                    "Column[" + columnName + ":" + className + "] -> " +
                    "Property[" + propName + ":" + objClass.getName() + "] ");
        }
        
        if (isPrimitiveType(objClass)) {
            // v~eBu^̏ꍇ
            if (Integer.TYPE.equals(objClass)) {
                if (obj instanceof Integer) {
                    return obj;
                } else if (obj instanceof Number) {
                    return new Integer(((Number)obj).intValue());
                } else if (obj == null) {
                    return new Integer(0);
                }
                throw new DaoSysException("Object is not instance of Integer or Number. obj=" + obj);
            }
            if (Long.TYPE.equals(objClass)) {
                if (obj instanceof Long) {
                    return obj;
                } else if (obj instanceof Number) {
                    return new Long(((Number)obj).longValue());
                } else if (obj == null) {
                    return new Long(0);
                }
                throw new DaoSysException("Object is not instance of Long or Number. obj=" + obj);
            }
            if (Short.TYPE.equals(objClass)) {
                if (obj instanceof Short) {
                    return obj;
                } else if (obj instanceof Number) {
                    return new Short(((Number)obj).shortValue());
                } else if (obj == null) {
                    return new Short((short)0 );
                }
                throw new DaoSysException("Object is not instance of Short or Number. obj=" + obj);
            }
            if (Float.TYPE.equals(objClass)) {
                if (obj instanceof Float) {
                    return obj;
                } else if (obj instanceof Number) {
                    return new Float(((Number)obj).floatValue());
                } else if (obj == null) {
                    return new Float(0.0f);
                }
                throw new DaoSysException("Object is not instance of Float or Number. obj=" + obj);
            }
            if (Double.TYPE.equals(objClass)) {
                if (obj instanceof Double) {
                    return obj;
                } else if (obj instanceof Number) {
                    return new Double(((Number)obj).doubleValue());
                } else if (obj == null) {
                    return new Double(0.0d);
                }
                throw new DaoSysException("Object is not instance of Double or Number. obj=" + obj);
            }
            if (Boolean.TYPE.equals(objClass)) {
                if (obj instanceof Boolean) {
                    return obj;
                } else if (obj == null) {
                    return new Boolean(false);
                }
                throw new DaoSysException("Object is not instance of Boolean. obj=" + obj);
            }
            if (Byte.TYPE.equals(objClass)) {
                if (obj instanceof Byte) {
                    return obj;
                } else if (obj == null) {
                    return new Byte((byte)0);
                }
                throw new DaoSysException("Object is not instance of Byte. obj=" + obj);
            }
            if (Character.TYPE.equals(objClass)) {
                if (obj instanceof Character) {
                    return obj;
                } else if (obj == null) {
                    return new Character('\u0000');
                }
                throw new DaoSysException("Object is not instance of Character. obj=" + obj);
            }
        } else if (obj instanceof Number) {
            // v~eBu^̃bpNX̏ꍇ
            if (Integer.class.equals(objClass)) {
                if (obj instanceof Integer) {
                    return obj;
                }
                return new Integer(((Number)obj).intValue());
            }
            if (Long.TYPE.equals(objClass)) {
                if (obj instanceof Long) {
                    return obj;
                }
                return new Long(((Number)obj).longValue());
            }
            if (Short.TYPE.equals(objClass)) {
                if (obj instanceof Short) {
                    return obj;
                }
                return new Short(((Number)obj).shortValue());
            }
            if (Float.TYPE.equals(objClass)) {
                if (obj instanceof Float) {
                    return obj;
                }
                return new Float(((Number)obj).floatValue());
            }
            if (Double.TYPE.equals(objClass)) {
                if (obj instanceof Double) {
                    return obj;
                }
                return new Double(((Number)obj).doubleValue());
            }
        }
        return obj;
    }
    
    private static boolean isPrimitiveType(Class objClass) {

        if (Integer.TYPE.equals(objClass)) {
            return true;
        }
        if (Long.TYPE.equals(objClass)) {
            return true;
        }
        if (Float.TYPE.equals(objClass)) {
            return true;
        }
        if (Double.TYPE.equals(objClass)) {
            return true;
        }
        if (Boolean.TYPE.equals(objClass)) {
            return true;
        }
        if (Short.TYPE.equals(objClass)) {
            return true;
        }
        if (Byte.TYPE.equals(objClass)) {
            return true;
        }
        if (Character.TYPE.equals(objClass)) {
            return true;
        }
        return false;
    }
}
