/*
 * Decompiled with CFR 0.152.
 */
package robbie.dao.x;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Text;
import robbie.dao.DaoTypes;
import robbie.dao.QuerySupport;
import robbie.dao.x.XDaoException;
import robbie.dao.x.XQueryHelper;

public class XQuery
extends QuerySupport {
    private static final Log LOG = LogFactory.getLog((Class)(class$robbie$dao$x$XQuery == null ? (class$robbie$dao$x$XQuery = XQuery.class$("robbie.dao.x.XQuery")) : class$robbie$dao$x$XQuery));
    protected String queryId = null;
    protected Element element = null;
    protected Map parameters = null;
    static /* synthetic */ Class class$robbie$dao$x$XQuery;

    public void setElement(Element element) {
        this.element = element;
    }

    public void setParameters(Map parameters) {
        this.parameters = parameters;
    }

    public void configure() {
        long startdate = 0L;
        if (LOG.isDebugEnabled()) {
            startdate = new Date().getTime();
            LOG.debug((Object)"start sql configure");
        }
        if (this.element == null) {
            throw new XDaoException("Query Element is NULL!");
        }
        this.prametersList = new ArrayList();
        this.queryId = this.element.getAttributeValue("id");
        this.sqlString = this.handleQueryElement(this.element);
        if (LOG.isDebugEnabled()) {
            long configuretime = new Date().getTime() - startdate;
            LOG.debug((Object)("end sql configure. time=" + configuretime + "(ms)"));
            LOG.debug((Object)this);
        }
    }

    protected String handleQueryElement(Element ele) {
        StringBuffer sqlStrBuff = new StringBuffer();
        List children = ele.getContent();
        Iterator it = children.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof String) {
                sqlStrBuff.append((String)obj);
                continue;
            }
            if (obj instanceof Text) {
                sqlStrBuff.append(((Text)obj).getText());
                continue;
            }
            String eleStr = null;
            Element child = (Element)obj;
            if (child.getName().equals("var")) {
                eleStr = this.handleVarElement(child);
            } else if (child.getName().equals("repeat")) {
                eleStr = this.handleRepeatElement(child);
            } else if (child.getName().equals("between")) {
                eleStr = this.handleBetweenElement(child);
            } else if (child.getName().equals("switch")) {
                eleStr = this.handleSwitchElement(child);
            } else if (child.getName().equals("list")) {
                eleStr = this.handleListElement(child);
            } else if (child.getName().equals("where")) {
                eleStr = this.handleWhereElement((Element)obj);
            } else {
                throw new XDaoException("Illegal element found! Name=" + ele.getName());
            }
            if (eleStr == null) continue;
            sqlStrBuff.append(eleStr);
        }
        if (XQueryHelper.isSpaceOnly(sqlStrBuff.toString())) {
            return null;
        }
        return sqlStrBuff.toString();
    }

    protected String handleConstElement(Element ele) {
        String sqlStr;
        String reqStr = ele.getAttributeValue("req");
        if (reqStr != null) {
            Boolean isRequired = Boolean.valueOf(reqStr);
            String keyStr = ele.getAttributeValue("key");
            if (isRequired.booleanValue()) {
                if (keyStr == null || keyStr.length() == 0 || !this.parameters.containsKey(keyStr)) {
                    throw new XDaoException("req is exsited. but, key don't set in const Element or parameter map.");
                }
            } else if (keyStr == null || keyStr.length() == 0 || !this.parameters.containsKey(keyStr)) {
                return null;
            }
        }
        if (XQueryHelper.isSpaceOnly(sqlStr = ele.getText())) {
            return null;
        }
        return sqlStr;
    }

    protected String handleVarElement(Element ele) {
        String keyStr = ele.getAttributeValue("key");
        if (keyStr == null) {
            throw new XDaoException("key don't set in var Element.");
        }
        if (this.parameters == null || !this.parameters.containsKey(keyStr)) {
            if (ele.getAttributeValue("req") == null) {
                throw new XDaoException("req don't set in var Element.");
            }
            Boolean isRequired = Boolean.valueOf(ele.getAttributeValue("req"));
            if (isRequired.booleanValue()) {
                throw new XDaoException("Don't set required parameter! query id=[" + this.element.getAttributeValue("id") + "] key=[" + keyStr + "]");
            }
            return null;
        }
        String typeStr = ele.getAttributeValue("type");
        Object valueObj = this.parameters.get(keyStr);
        if (valueObj != null && valueObj.getClass().isArray()) {
            valueObj = ((Object[])valueObj)[0];
        }
        if (ele.getAttribute("like") != null) {
            valueObj = this.handleLikeAttribute(ele.getAttributeValue("like"), valueObj);
        }
        HashMap parameterMap = new HashMap();
        parameterMap.put("value", valueObj);
        parameterMap.put("type", DaoTypes.getSQLType(typeStr));
        this.prametersList.add(parameterMap);
        return ele.getText();
    }

    protected String handleRepeatElement(Element ele) {
        String keyStr = ele.getAttributeValue("key");
        if (keyStr == null) {
            throw new XDaoException("key don't set in repeat resourceListElement.");
        }
        if (this.parameters == null || !this.parameters.containsKey(keyStr)) {
            if (ele.getAttributeValue("req") == null) {
                throw new XDaoException("req don't set in repeat Element.");
            }
            Boolean isRequired = Boolean.valueOf(ele.getAttributeValue("req"));
            if (isRequired.booleanValue()) {
                throw new XDaoException("Don't set required parameter! query id=[" + this.element.getAttributeValue("id") + "] key=[" + keyStr + "]");
            }
            return null;
        }
        String sqlStr = null;
        String typeStr = ele.getAttributeValue("type");
        Object valueObj = this.parameters.get(keyStr);
        if (valueObj.getClass().isArray()) {
            Object[] valueArray = (Object[])valueObj;
            if (valueArray.length == 0) {
                return null;
            }
            StringBuffer bindStr = new StringBuffer();
            for (int i = 0; i < valueArray.length; ++i) {
                if (i > 0) {
                    bindStr.append(", ?");
                } else {
                    bindStr.append("?");
                }
                Object setValue = valueArray[i];
                if (ele.getAttribute("like") != null) {
                    setValue = this.handleLikeAttribute(ele.getAttributeValue("like"), setValue);
                }
                HashMap<String, Object> parameterMap = new HashMap<String, Object>();
                parameterMap.put("value", setValue);
                parameterMap.put("type", DaoTypes.getSQLType(typeStr));
                this.prametersList.add(parameterMap);
            }
            sqlStr = ele.getText().replaceFirst("[?]", bindStr.toString());
        } else {
            sqlStr = this.handleVarElement(ele);
        }
        return sqlStr;
    }

    protected String handleBetweenElement(Element ele) {
        Object valueTo;
        String fromKey = ele.getAttributeValue("from");
        if (fromKey == null) {
            throw new XDaoException("'from' is not set in between between Element.");
        }
        String toKey = ele.getAttributeValue("to");
        if (toKey == null) {
            throw new XDaoException("'to' is not set in between between Element.");
        }
        if (this.parameters == null || !this.parameters.containsKey(fromKey) || !this.parameters.containsKey(toKey)) {
            if (ele.getAttributeValue("req") == null) {
                throw new XDaoException("req don't set in between Element.");
            }
            Boolean isRequired = Boolean.valueOf(ele.getAttributeValue("req"));
            if (isRequired.booleanValue()) {
                throw new XDaoException("Don't set required parameter! query id=[" + this.element.getAttributeValue("id") + "] from key=[" + fromKey + "] to key=[" + toKey + "]");
            }
            return null;
        }
        String sqlStr = null;
        Object valueFrom = this.parameters.get(fromKey);
        if (valueFrom != null && valueFrom.getClass().isArray()) {
            valueFrom = ((Object[])valueFrom)[0];
        }
        if ((valueTo = this.parameters.get(toKey)) != null && valueTo.getClass().isArray()) {
            valueTo = ((Object[])valueTo)[0];
        }
        HashMap parameterMap = new HashMap();
        parameterMap.put("value", valueFrom);
        parameterMap.put("type", null);
        this.prametersList.add(parameterMap);
        parameterMap = new HashMap();
        parameterMap.put("value", valueTo);
        parameterMap.put("type", null);
        this.prametersList.add(parameterMap);
        sqlStr = ele.getText();
        return sqlStr;
    }

    protected String handleSwitchElement(Element ele) {
        Element defaultCase;
        String keyStr = ele.getAttributeValue("key");
        if (keyStr == null) {
            return null;
        }
        if (this.parameters != null && this.parameters.containsKey(keyStr)) {
            Object valueObj = this.parameters.get(keyStr);
            if (valueObj == null) {
                return null;
            }
            List children = ele.getChildren("case");
            Iterator it = children.iterator();
            while (it.hasNext()) {
                Element child = (Element)it.next();
                if (!((String)valueObj).equals(child.getAttributeValue("value"))) continue;
                return this.handleQueryElement(child);
            }
        }
        if ((defaultCase = ele.getChild("default")) == null) {
            return null;
        }
        return this.handleQueryElement(defaultCase);
    }

    protected String handleListElement(Element ele) {
        StringBuffer sqlStrBuff = new StringBuffer();
        String joinStr = " ";
        if (ele.getAttribute("join") != null) {
            joinStr = " " + ele.getAttributeValue("join") + " ";
        }
        boolean isFirstContent = true;
        List contents = ele.getContent();
        Iterator it = contents.iterator();
        while (it.hasNext()) {
            StringBuffer buf;
            Object obj = it.next();
            if (obj instanceof String && XQueryHelper.isSpaceOnly((String)obj)) {
                sqlStrBuff.append((String)obj);
                continue;
            }
            if (obj instanceof Text && XQueryHelper.isSpaceOnly(((Text)obj).getText())) {
                sqlStrBuff.append(((Text)obj).getText());
                continue;
            }
            if (!(obj instanceof Element)) continue;
            String eleStr = null;
            String eleType = ((Element)obj).getName();
            if (eleType.equals("list")) {
                eleStr = this.handleListElement((Element)obj);
                if (eleStr != null) {
                    buf = new StringBuffer();
                    buf.append(" ( ");
                    buf.append(eleStr);
                    buf.append(" ) ");
                    eleStr = buf.toString();
                }
            } else if (eleType.equals("switch")) {
                eleStr = this.handleSwitchElement((Element)obj);
                if (eleStr != null) {
                    buf = new StringBuffer();
                    buf.append(" ( ");
                    buf.append(eleStr);
                    buf.append(" ) ");
                    eleStr = buf.toString();
                }
            } else if (eleType.equals("subquery")) {
                eleStr = this.handleQueryElement((Element)obj);
                if (eleStr != null) {
                    buf = new StringBuffer();
                    buf.append(" ( ");
                    buf.append(eleStr);
                    buf.append(" ) ");
                    eleStr = buf.toString();
                }
            } else if (eleType.equals("const")) {
                eleStr = this.handleConstElement((Element)obj);
            } else if (eleType.equals("var")) {
                eleStr = this.handleVarElement((Element)obj);
            } else if (eleType.equals("repeat")) {
                eleStr = this.handleRepeatElement((Element)obj);
            } else if (eleType.equals("between")) {
                eleStr = this.handleBetweenElement((Element)obj);
            } else {
                throw new XDaoException("Illegal element. Not found element Name=" + ((Element)obj).getName());
            }
            if (eleStr == null) continue;
            if (isFirstContent) {
                sqlStrBuff.append(" ").append(eleStr);
                isFirstContent = false;
                continue;
            }
            sqlStrBuff.append(joinStr).append(eleStr);
        }
        String sqlStr = sqlStrBuff.toString();
        if (XQueryHelper.isSpaceOnly(sqlStr)) {
            return null;
        }
        return sqlStr;
    }

    protected String handleWhereElement(Element ele) {
        String sqlStr;
        if (ele.getAttribute("join") == null) {
            Attribute attr = new Attribute("join", "AND");
            ele.setAttribute(attr);
        }
        if ((sqlStr = this.handleListElement(ele)) != null) {
            StringBuffer buf = new StringBuffer("WHERE ");
            buf.append(sqlStr);
            sqlStr = buf.toString();
        }
        return sqlStr;
    }

    protected Object handleLikeAttribute(String likeStr, Object valueObj) {
        if (valueObj instanceof String) {
            if ("%?%".equals(likeStr)) {
                StringBuffer buf = new StringBuffer();
                buf.append("%");
                buf.append((String)valueObj);
                buf.append("%");
                return buf.toString();
            }
            if ("?%".equals(likeStr)) {
                StringBuffer buf = new StringBuffer();
                buf.append((String)valueObj);
                buf.append("%");
                return buf.toString();
            }
            if ("%?".equals(likeStr)) {
                StringBuffer buf = new StringBuffer();
                buf.append("%");
                buf.append((String)valueObj);
                return buf.toString();
            }
        }
        return valueObj;
    }

    public String toString() {
        String ls = System.getProperty("line.separator");
        return ls + "Query-ID=[" + this.queryId + "]" + super.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

