/*
 * Decompiled with CFR 0.152.
 */
package robbie.dao.x;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jdom.Element;
import robbie.dao.x.DataSourceResource;
import robbie.dao.x.JdbcOdbcResource;
import robbie.dao.x.JdbcResource;
import robbie.dao.x.XDaoException;
import robbie.dao.x.XDbResource;

public class XDbResourceFactory {
    protected Map resourceMap = new HashMap();

    public XDbResource getDbResource(String id) {
        return (XDbResource)this.resourceMap.get(id);
    }

    public void configure(Element resourceListElement) {
        List list = resourceListElement.getChildren("resource");
        if (list != null && list.size() > 0) {
            HashMap<String, XDbResource> map = new HashMap<String, XDbResource>();
            Iterator it = list.iterator();
            while (it.hasNext()) {
                Element ele = (Element)it.next();
                String id = ele.getAttributeValue("id");
                String type = ele.getAttributeValue("type");
                map.put(id, this.createXDbResource(type, ele));
            }
            this.resourceMap = map;
        }
    }

    protected XDbResource createXDbResource(String type, Element ele) {
        XDbResource resource = null;
        if ("DataSource".equals(type)) {
            String jndiName = ele.getChild("jndi-name").getText();
            resource = new DataSourceResource(jndiName);
        } else if ("JDBC".equals(type)) {
            Properties env = new Properties();
            env.put("driver.class.name", ele.getChild("driver").getText());
            env.put("server.url", ele.getChild("url").getText());
            env.put("username", ele.getChild("username").getText());
            env.put("password", ele.getChild("password").getText());
            resource = new JdbcResource(env);
        } else if ("JDBC-ODBC".equals(type)) {
            String sourceName = ele.getChild("odbc-data-source").getText();
            resource = new JdbcOdbcResource(sourceName);
        } else {
            throw new XDaoException("Resource type not mattched. type=" + type);
        }
        return resource;
    }
}

