/*
 * Decompiled with CFR 0.152.
 */
package robbie.dao.x;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Element;
import robbie.dao.x.XDao;
import robbie.dao.x.XDaoException;
import robbie.dao.x.XDbResourceFactory;
import robbie.dao.x.XQueryFactory;
import robbie.util.InstanceFactory;
import robbie.util.JdomXmlLoadHelper;

public class XDaoFactory
implements Serializable {
    private static final Log LOG = LogFactory.getLog((Class)(class$robbie$dao$x$XDaoFactory == null ? (class$robbie$dao$x$XDaoFactory = XDaoFactory.class$("robbie.dao.x.XDaoFactory")) : class$robbie$dao$x$XDaoFactory));
    protected String xQueryFactoryClassName = (class$robbie$dao$x$XQueryFactory == null ? (class$robbie$dao$x$XQueryFactory = XDaoFactory.class$("robbie.dao.x.XQueryFactory")) : class$robbie$dao$x$XQueryFactory).getName();
    protected String xDBResourceFactoryClassName = (class$robbie$dao$x$XDbResourceFactory == null ? (class$robbie$dao$x$XDbResourceFactory = XDaoFactory.class$("robbie.dao.x.XDbResourceFactory")) : class$robbie$dao$x$XDbResourceFactory).getName();
    protected String filepath = null;
    protected XQueryFactory queryFactory = null;
    protected XDbResourceFactory resourceFactory = null;
    protected Map daoNameMap = null;
    protected Map daoResRefMap = null;
    protected long lastModifiedTimestamp = 0L;
    protected boolean isValidate = false;
    static /* synthetic */ Class class$robbie$dao$x$XDaoFactory;
    static /* synthetic */ Class class$robbie$dao$x$XQueryFactory;
    static /* synthetic */ Class class$robbie$dao$x$XDbResourceFactory;

    private XDaoFactory() {
    }

    public XDaoFactory(String filepath) {
        try {
            this.configure(new FileInputStream(filepath));
            this.filepath = filepath;
            this.lastModifiedTimestamp = new File(filepath).lastModified();
        }
        catch (FileNotFoundException ex) {
            throw new XDaoException("file not found. filepath = " + filepath, ex);
        }
    }

    public XDaoFactory(InputStream inputStream) {
        this.configure(inputStream);
    }

    public XDao createDaoInstance(String id, ClassLoader loader) {
        this.reconfigureIfNeeded();
        if (!this.daoNameMap.containsKey(id)) {
            throw new XDaoException("id =[" + id + "] not definition in config xml file.");
        }
        Object obj = InstanceFactory.createInstance((String)this.daoNameMap.get(id), loader);
        XDao dao = (XDao)obj;
        dao.setQueryFactory(this.queryFactory);
        dao.setResource(this.resourceFactory.getDbResource((String)this.daoResRefMap.get(id)));
        dao.configure();
        return dao;
    }

    public XDao createDaoInstance(String id) {
        return this.createDaoInstance(id, null);
    }

    protected void configure(InputStream inputStream) {
        Element root = this.loadRootElemet(inputStream);
        this.configureQueryFactory(root);
        this.configureResourceFactory(root);
        this.conifgureDAOMap(root);
    }

    protected void reconfigureIfNeeded() {
        long nowLastModifiedTimestamp;
        if (this.filepath != null && (nowLastModifiedTimestamp = new File(this.filepath).lastModified()) > this.lastModifiedTimestamp) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("reload config file. filepath=" + this.filepath + " Old last timestamp = " + new Date(this.lastModifiedTimestamp) + " New last timestamp = " + new Date(nowLastModifiedTimestamp)));
            }
            try {
                this.configure(new FileInputStream(this.filepath));
                this.lastModifiedTimestamp = nowLastModifiedTimestamp;
            }
            catch (FileNotFoundException ex) {
                throw new XDaoException("file not found. filepath=" + this.filepath, ex);
            }
        }
    }

    protected Element loadRootElemet(InputStream inputStream) {
        try {
            return JdomXmlLoadHelper.load(inputStream, this.isValidate);
        }
        catch (Exception ex) {
            throw new XDaoException("catch exception, when load config xml files.", ex);
        }
    }

    protected void configureQueryFactory(Element root) {
        XQueryFactory factory = (XQueryFactory)InstanceFactory.createInstance(this.xQueryFactoryClassName);
        factory.configure(root.getChild("query-list"));
        this.queryFactory = factory;
    }

    protected void configureResourceFactory(Element root) {
        XDbResourceFactory factory = (XDbResourceFactory)InstanceFactory.createInstance(this.xDBResourceFactoryClassName);
        factory.configure(root.getChild("resource-list"));
        this.resourceFactory = factory;
    }

    protected void conifgureDAOMap(Element root) {
        Element resourceList = root.getChild("dao-list");
        List list = resourceList.getChildren("dao");
        if (list != null && list.size() > 0) {
            HashMap<String, String> nameMap = new HashMap<String, String>();
            HashMap<String, String> refMap = new HashMap<String, String>();
            Iterator it = list.iterator();
            while (it.hasNext()) {
                Element ele = (Element)it.next();
                String id = ele.getAttributeValue("id");
                String calssName = ele.getChild("class").getText();
                String refResoauce = ele.getChild("resource-ref").getText();
                nameMap.put(id, calssName);
                refMap.put(id, refResoauce);
            }
            this.daoNameMap = nameMap;
            this.daoResRefMap = refMap;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

